/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.gui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.modcs.tools.Util.Util;
import org.modcs.tools.rbd.evaluatorrbd.BlockImportance;
import org.modcs.tools.rbd.evaluatorrbd.ReliabilityImportance;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;
import org.modcs.tools.rbd.gui.ChartCategory;

public class JDialogReliabilityImportance
extends JDialog {
    private JButton jButtonEvaluate;
    private JLabel jLabel1;
    private JPanel jPanelChart;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTextArea jTextArea1;
    private JTextField jTextTime;

    public JDialogReliabilityImportance(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jButtonEvaluate = new JButton();
        this.jTextTime = new JTextField();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jPanelChart = new JPanel();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Reliability Importance");
        this.jButtonEvaluate.setText("Evaluate");
        this.jButtonEvaluate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogReliabilityImportance.this.jButtonEvaluateActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        GroupLayout jPanelChartLayout = new GroupLayout(this.jPanelChart);
        this.jPanelChart.setLayout(jPanelChartLayout);
        jPanelChartLayout.setHorizontalGroup(jPanelChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 701, Short.MAX_VALUE));
        jPanelChartLayout.setVerticalGroup(jPanelChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 267, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.jPanelChart);
        this.jLabel1.setText("Time:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSplitPane1, GroupLayout.Alignment.LEADING, -1, 703, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextTime, -1, 582, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonEvaluate))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonEvaluate).addComponent(this.jTextTime, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 523, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jButtonEvaluateActionPerformed(ActionEvent evt) {
        double time = Double.valueOf(this.jTextTime.getText());
        System.out.println("Time: " + time);
        ReliabilityImportance rImportance = new ReliabilityImportance(GraphViewRBD.app.getRBDModel(), time);
        String result = "";
        ArrayList<BlockImportance> blockImportances = rImportance.getReliabilityImportance();
        Collections.sort(blockImportances);
        double higherImportance = blockImportances.get(0).getNormalizedImportance();
        if (Double.isNaN(higherImportance)) {
            JOptionPane.showMessageDialog(this, "Out of Range!, insert lower times");
            return;
        }
        for (int i = 0; i < blockImportances.size(); ++i) {
            BlockImportance blockImportanceActual = blockImportances.get(i);
            if (blockImportanceActual.getNormalizedImportance() == 0.0) {
                blockImportances.remove(blockImportances.get(i));
                continue;
            }
            result = result + "Component: " + blockImportanceActual.getName();
            result = result + "\nImportance: " + blockImportanceActual.getNormalizedImportance() + "\n\n";
        }
        this.jTextArea1.setText(result);
        Util.refreshScreen((JPanel)ChartCategory.createChartPanel(blockImportances), this.jPanelChart);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JDialogReliabilityImportance dialog = new JDialogReliabilityImportance((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

