/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.graphrbd;

import com.local.gui.JFrameDesdacTool;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockBridge;
import org.modcs.tools.rbd.blocks.BlockParallel;
import org.modcs.tools.rbd.blocks.RBDModel;
import org.modcs.tools.rbd.evaluatorrbd.ApplicationRBD;
import org.modcs.tools.rbd.graphrbd.ConnectionBlock;
import org.modcs.tools.rbd.graphrbd.GraphEdRBD;
import org.modcs.tools.rbd.gui.MainScreen;

public class GraphViewRBD {
    public static JGraph graph;
    public static ArrayList<DefaultGraphCell> cells;
    public static ImageIcon blockIconEdited;
    public static ImageIcon blockIconNotEdited;
    public static GraphEdRBD graphEd;
    public static int BLOCK_SIZE_X;
    public static int BLOCK_SIZE_Y;
    public static int BLOCK_SEPARATION;
    public static ApplicationRBD app;
    public static MainScreen mainScreen;
    public static JScrollPane jScroll;
    public static JFrameDesdacTool jFrameDesdacTool;

    public static void paint() {
        cells = null;
        graph = null;
        System.gc();
        GraphViewRBD.GraphViewInit(app, mainScreen, jScroll, jFrameDesdacTool);
        GraphViewRBD.insertStartNodes(jScroll, app.getRBDModel());
        GraphViewRBD.generateRBDModel(app.getRBDModel(), jScroll);
        jScroll.setViewportView((Component)graph);
        jFrameDesdacTool.updateJTree(app);
    }

    public static void DestroyRBD() {
        graph = null;
        cells = null;
        app = null;
        mainScreen = null;
        jScroll = null;
        graphEd = null;
        System.gc();
    }

    public static void GraphViewInit(ApplicationRBD app, MainScreen mainScreen, JScrollPane jScroll, JFrameDesdacTool jFrameDesdacTool) {
        cells = null;
        graph = null;
        System.gc();
        DefaultGraphModel model = new DefaultGraphModel();
        GraphLayoutCache view = new GraphLayoutCache((GraphModel)model, (CellViewFactory)new DefaultCellViewFactory());
        graph = new JGraph((GraphModel)model, view);
        cells = new ArrayList();
        GraphViewRBD.app = app;
        GraphViewRBD.mainScreen = mainScreen;
        GraphViewRBD.jScroll = jScroll;
        graphEd = new GraphEdRBD(app, jScroll, graph);
        GraphViewRBD.jFrameDesdacTool = jFrameDesdacTool;
    }

    public static void GraphViewInit(ApplicationRBD app, MainScreen mainScreen) {
        cells = null;
        graph = null;
        System.gc();
        DefaultGraphModel model = new DefaultGraphModel();
        GraphLayoutCache view = new GraphLayoutCache((GraphModel)model, (CellViewFactory)new DefaultCellViewFactory());
        graph = new JGraph((GraphModel)model, view);
        cells = new ArrayList();
        GraphViewRBD.app = app;
        GraphViewRBD.mainScreen = mainScreen;
        graphEd = new GraphEdRBD(app, jScroll, graph);
    }

    public static void insertStartNodes(JScrollPane jScroll, RBDModel rbdModel) {
        int currentY = rbdModel.getModel().getLengthYPixels() > jScroll.getHeight() ? rbdModel.getModel().getLengthYPixels() / 2 : jScroll.getHeight() / 2;
        Hashtable map = new Hashtable();
        DefaultGraphCell begin = new DefaultGraphCell((Object)new String("BEGIN"));
        DefaultGraphCell end = new DefaultGraphCell((Object)new String("END"));
        cells.add(begin);
        cells.add(end);
        GraphConstants.setResize(map, (boolean)false);
        GraphConstants.setEditable(map, (boolean)false);
        GraphConstants.setMoveable(map, (boolean)false);
        begin.getAttributes().applyMap(map);
        end.getAttributes().applyMap(map);
        Object[] arrayCells = new DefaultGraphCell[cells.size()];
        arrayCells = cells.toArray();
        GraphConstants.setBounds((Map)arrayCells[0].getAttributes(), (Rectangle2D)new Rectangle2D.Double(0.0, currentY, BLOCK_SIZE_X, BLOCK_SIZE_Y));
        GraphConstants.setBounds((Map)arrayCells[1].getAttributes(), (Rectangle2D)new Rectangle2D.Double(BLOCK_SIZE_X + 2 * BLOCK_SEPARATION + rbdModel.getModel().getLengthXPixels(), currentY, BLOCK_SIZE_X, BLOCK_SIZE_Y));
        arrayCells[0].addPort((Point2D)new Point2D.Double(1000.0, 500.0));
        arrayCells[1].addPort((Point2D)new Point2D.Double(0.0, 500.0));
        graph.getGraphLayoutCache().insert(arrayCells);
        graph.getGraphLayoutCache().cellViewsChanged(graph.getGraphLayoutCache().getAllViews());
    }

    public static void generateRBDModel(RBDModel rbdModel, JScrollPane jScrollPane) {
        int currentY = rbdModel.getModel().getLengthYPixels() > jScrollPane.getHeight() ? rbdModel.getModel().getLengthYPixels() / 2 : jScrollPane.getHeight() / 2;
        ConnectionBlock connectionBlock = rbdModel.getModel().drawBlock(BLOCK_SIZE_X + BLOCK_SEPARATION, currentY);
        DefaultEdge edgeToBegin = new DefaultEdge();
        DefaultEdge edgeToEnd = new DefaultEdge();
        cells.add((DefaultGraphCell)edgeToBegin);
        cells.add((DefaultGraphCell)edgeToEnd);
        Object[] arrayCells = new DefaultGraphCell[cells.size()];
        arrayCells = cells.toArray();
        edgeToBegin.setSource((Object)((DefaultPort)arrayCells[0].getChildAt(0)));
        edgeToBegin.setTarget((Object)connectionBlock.getLeftPort());
        edgeToEnd.setSource((Object)connectionBlock.getRightPort());
        edgeToEnd.setTarget((Object)((DefaultPort)arrayCells[1].getChildAt(0)));
        graph.getGraphLayoutCache().insert(arrayCells);
        graph.setPortsVisible(true);
        graph.getGraphLayoutCache().cellViewsChanged(graph.getGraphLayoutCache().getAllViews());
    }

    public static void drawEvenBlocksParallel(BlockParallel block, int x, int y, ConnectionBlock connectionBlock) {
        int lengthYMaxBlock = block.getMaxLengthYPixels() + BLOCK_SEPARATION;
        int currentY = y - ((block.getBlocks().size() / 2 - 1) * lengthYMaxBlock + lengthYMaxBlock / 2);
        int lengthXPixels = block.getLengthXPixels();
        for (int i = 0; i < block.getBlocks().size(); ++i) {
            ConnectionBlock connectionBlockTemp = block.getBlocks().get(i).drawBlock(x + BLOCK_SEPARATION, currentY);
            GraphViewRBD.orthogonalConnectBlocks(connectionBlock.getLeftPort(), connectionBlockTemp.getLeftPort(), x, currentY + BLOCK_SIZE_Y / 2);
            GraphViewRBD.orthogonalConnectBlocks(connectionBlockTemp.getRightPort(), connectionBlock.getRightPort(), x + lengthXPixels, currentY + BLOCK_SIZE_Y / 2);
            currentY += lengthYMaxBlock;
        }
    }

    public static void drawOddBlocksParallel(BlockParallel block, int x, int y, ConnectionBlock connectionBlock) {
        int lengthYMaxBlock = block.getMaxLengthYPixels() + BLOCK_SEPARATION;
        int currentY = y - lengthYMaxBlock * (block.getBlocks().size() / 2);
        int lengthXPixels = block.getLengthXPixels();
        for (int i = 0; i < block.getBlocks().size(); ++i) {
            ConnectionBlock connectionBlockTemp = block.getBlocks().get(i).drawBlock(x + BLOCK_SEPARATION, currentY);
            GraphViewRBD.orthogonalConnectBlocks(connectionBlock.getLeftPort(), connectionBlockTemp.getLeftPort(), x, currentY + BLOCK_SIZE_Y / 2);
            GraphViewRBD.orthogonalConnectBlocks(connectionBlockTemp.getRightPort(), connectionBlock.getRightPort(), x + lengthXPixels, currentY + BLOCK_SIZE_Y / 2);
            currentY += lengthYMaxBlock;
        }
    }

    public static ConnectionBlock drawBeginEndOfBlock(Block block, int x, int y) {
        DefaultGraphCell beginVertex = new DefaultGraphCell();
        DefaultGraphCell endVertex = new DefaultGraphCell();
        GraphConstants.setBounds((Map)beginVertex.getAttributes(), (Rectangle2D)new Rectangle2D.Double(x, y, 0.0, 0.0));
        GraphConstants.setBounds((Map)endVertex.getAttributes(), (Rectangle2D)new Rectangle2D.Double(x + block.getLengthXPixels(), y, 0.0, 0.0));
        DefaultPort beginPort = new DefaultPort((Object)new Point2D.Double(0.0, 0.0));
        DefaultPort endPort = new DefaultPort((Object)new Point2D.Double(0.0, 0.0));
        ConnectionBlock connectionBlock = new ConnectionBlock(beginPort, endPort);
        beginVertex.add((MutableTreeNode)beginPort);
        endVertex.add((MutableTreeNode)endPort);
        cells.add(beginVertex);
        cells.add(endVertex);
        Object[] arrayCells = new DefaultGraphCell[cells.size()];
        arrayCells = cells.toArray();
        graph.getGraphLayoutCache().insert(arrayCells);
        return connectionBlock;
    }

    public static void drawBlockBridge(BlockBridge blockBridge, int x, int y, ConnectionBlock connectionBlock) {
        ConnectionBlock upLeftConnectionBlock = blockBridge.getBlocks().get(BlockBridge.INDEX_LEFT_UP_BLOCK).drawBlock(x + BLOCK_SEPARATION, y - BLOCK_SIZE_Y - BLOCK_SIZE_Y / 2 - BLOCK_SEPARATION);
        GraphViewRBD.orthogonalConnectBlocks(connectionBlock.getLeftPort(), upLeftConnectionBlock.getLeftPort(), x, y - BLOCK_SIZE_Y - BLOCK_SEPARATION);
        ConnectionBlock bottomLeftConnectionBlock = blockBridge.getBlocks().get(BlockBridge.INDEX_LEFT_BOTTOM_BLOCK).drawBlock(x + BLOCK_SEPARATION, y + BLOCK_SIZE_Y / 2 + BLOCK_SEPARATION);
        GraphViewRBD.orthogonalConnectBlocks(connectionBlock.getLeftPort(), bottomLeftConnectionBlock.getLeftPort(), x, y + BLOCK_SIZE_Y + BLOCK_SEPARATION);
        ConnectionBlock centralConnectionBlock = blockBridge.getBlocks().get(BlockBridge.INDEX_CENTRAL_BLOCK).drawBlock(x + 2 * BLOCK_SEPARATION + BLOCK_SIZE_X, y - BLOCK_SIZE_Y / 2);
        GraphViewRBD.orthogonalConnectBlocks(upLeftConnectionBlock.getRightPort(), centralConnectionBlock.getLeftPort(), x + 2 * BLOCK_SEPARATION + BLOCK_SIZE_X + BLOCK_SIZE_X / 2, y - BLOCK_SIZE_Y - BLOCK_SEPARATION);
        GraphViewRBD.orthogonalConnectBlocks(bottomLeftConnectionBlock.getRightPort(), centralConnectionBlock.getLeftPort(), x + 2 * BLOCK_SEPARATION + BLOCK_SIZE_X + BLOCK_SIZE_X / 2, y + BLOCK_SIZE_Y + BLOCK_SEPARATION);
        ConnectionBlock upRightConnectionBlock = blockBridge.getBlocks().get(BlockBridge.INDEX_RIGHT_UP_BLOCK).drawBlock(x + 3 * BLOCK_SEPARATION + 2 * BLOCK_SIZE_X, y - BLOCK_SIZE_Y - BLOCK_SIZE_Y / 2 - BLOCK_SEPARATION);
        GraphViewRBD.orthogonalConnectBlocks(centralConnectionBlock.getRightPort(), upRightConnectionBlock.getLeftPort(), x + 2 * BLOCK_SEPARATION + BLOCK_SIZE_X + BLOCK_SIZE_X / 2, y - BLOCK_SIZE_Y - BLOCK_SEPARATION);
        ConnectionBlock bottomRightConnectionBlock = blockBridge.getBlocks().get(BlockBridge.INDEX_RIGHT_BOTTOM_BLOCK).drawBlock(x + 3 * BLOCK_SEPARATION + 2 * BLOCK_SIZE_X, y + BLOCK_SIZE_Y / 2 + BLOCK_SEPARATION);
        GraphViewRBD.orthogonalConnectBlocks(centralConnectionBlock.getLeftPort(), bottomRightConnectionBlock.getLeftPort(), x + 2 * BLOCK_SEPARATION + BLOCK_SIZE_X + BLOCK_SIZE_X / 2, y + BLOCK_SIZE_Y + BLOCK_SEPARATION);
        GraphViewRBD.orthogonalConnectBlocks(upRightConnectionBlock.getLeftPort(), connectionBlock.getRightPort(), x + 4 * BLOCK_SEPARATION + 3 * BLOCK_SIZE_X, y - BLOCK_SIZE_Y - BLOCK_SEPARATION);
        GraphViewRBD.orthogonalConnectBlocks(bottomRightConnectionBlock.getLeftPort(), connectionBlock.getRightPort(), x + 4 * BLOCK_SEPARATION + 3 * BLOCK_SIZE_X, y + BLOCK_SIZE_Y + BLOCK_SEPARATION);
    }

    public static void orthogonalConnectBlocks(DefaultPort leftBlock, DefaultPort rightBlock, int x, int y) {
        DefaultEdge link = new DefaultEdge();
        cells.add((DefaultGraphCell)link);
        Object[] arrayCells = new DefaultGraphCell[cells.size()];
        arrayCells = cells.toArray();
        link.setSource((Object)leftBlock);
        link.setTarget((Object)rightBlock);
        ArrayList<Object> newPoints = new ArrayList<Object>();
        newPoints.add(leftBlock);
        newPoints.add(new Point2D.Double(x, y));
        newPoints.add(rightBlock);
        GraphConstants.setPoints((Map)link.getAttributes(), newPoints);
        GraphConstants.setLineStyle((Map)link.getAttributes(), (int)11);
        graph.getGraphLayoutCache().insert(arrayCells);
    }

    public static void connectBlocks(DefaultPort leftBlock, DefaultPort rightBlock) {
        DefaultEdge link = new DefaultEdge();
        cells.add((DefaultGraphCell)link);
        Object[] arrayCells = new DefaultGraphCell[cells.size()];
        arrayCells = cells.toArray();
        link.setSource((Object)leftBlock);
        link.setTarget((Object)rightBlock);
        graph.getGraphLayoutCache().insert(arrayCells);
    }

    public static ConnectionBlock drawBlock(Block b, int x, int y) {
        Hashtable map = new Hashtable();
        DefaultPort leftPort = new DefaultPort((Object)new Point2D.Double(0.0, 500.0));
        DefaultPort rightPort = new DefaultPort((Object)new Point2D.Double(1000.0, 500.0));
        ConnectionBlock connectionBlock = new ConnectionBlock(leftPort, rightPort);
        DefaultGraphCell block = new DefaultGraphCell((Object)b.getName());
        block.setUserObject((Object)b);
        block.add((MutableTreeNode)leftPort);
        block.add((MutableTreeNode)rightPort);
        cells.add(block);
        Object[] arrayCells = new DefaultGraphCell[cells.size()];
        arrayCells = cells.toArray();
        GraphConstants.setBounds(map, (Rectangle2D)new Rectangle2D.Double(x, y, BLOCK_SIZE_X, BLOCK_SIZE_Y));
        GraphConstants.setEditable(map, (boolean)false);
        GraphConstants.setResize(map, (boolean)true);
        GraphConstants.setAutoSize(map, (boolean)true);
        GraphConstants.setVerticalAlignment(map, (int)3);
        GraphConstants.setHorizontalAlignment(map, (int)2);
        GraphConstants.setLabelEnabled(map, (boolean)false);
        GraphConstants.setDisconnectable(map, (boolean)false);
        GraphConstants.setMoveable(map, (boolean)false);
        block.getAttributes().applyMap(map);
        if (!b.isBlockHasReliabilityEdited() && !b.isBlockHasMaintainabilityEdited()) {
            GraphConstants.setIcon((Map)block.getAttributes(), (Icon)blockIconNotEdited);
        } else {
            GraphConstants.setIcon((Map)block.getAttributes(), (Icon)blockIconEdited);
        }
        graph.getGraphLayoutCache().insert(arrayCells);
        return connectionBlock;
    }

    static {
        BLOCK_SIZE_X = 80;
        BLOCK_SIZE_Y = 90;
        BLOCK_SEPARATION = 30;
    }
}

