/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.evaluatorrbd;

import java.util.ArrayList;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockBridge;
import org.modcs.tools.rbd.blocks.BlockChain;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.blocks.RBDModel;
import org.modcs.tools.rbd.evaluatorrbd.BlockImportance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReliabilityImportance {
    private ArrayList<BlockImportance> rImportance = new ArrayList();
    private double biggestImportanceValue = 0.0;

    public ReliabilityImportance(RBDModel rBDModel, double time) {
        this.calculateBlockImportance(rBDModel.getModel(), rBDModel, time);
        for (int i = 0; i < this.rImportance.size(); ++i) {
            this.rImportance.get(i).setNormalizedImportance(this.rImportance.get(i).getImportance() / this.biggestImportanceValue);
        }
    }

    private void calculateBlockImportance(Block block, RBDModel rBDModel, double time) {
        if (block instanceof BlockChain) {
            for (int i = 0; i < ((BlockChain)block).getBlocks().size(); ++i) {
                this.calculateBlockImportance(((BlockChain)block).getBlocks().get(i), rBDModel, time);
            }
        } else if (block instanceof BlockBridge) {
            for (int i = 0; i < 5; ++i) {
                this.calculateBlockImportance(((BlockBridge)block).getBlocks().get(i), rBDModel, time);
            }
        } else {
            BlockImportance blockImp = new BlockImportance();
            blockImp.setName(block.getName());
            ((BlockExponential)block).setStateWorking();
            RBDModel icalculatorRBD = rBDModel;
            double bImportance = icalculatorRBD.getReliability(time);
            blockImp.setReliabilityBlockIn(bImportance);
            ((BlockExponential)block).setStateBroken();
            icalculatorRBD = rBDModel;
            blockImp.setReliabilityBlockOut(icalculatorRBD.getReliability(time));
            blockImp.setImportance(bImportance -= blockImp.getReliabilityBlockOut());
            if (bImportance > this.biggestImportanceValue) {
                this.biggestImportanceValue = bImportance;
            }
            ((BlockExponential)block).setStateDefault();
            this.rImportance.add(blockImp);
        }
    }

    public BlockImportance getImportanceOfBlock(String blockName) {
        for (BlockImportance bImp : this.rImportance) {
            if (!bImp.getName().equals(blockName)) continue;
            return bImp;
        }
        return null;
    }

    public ArrayList<BlockImportance> getReliabilityImportance() {
        return this.rImportance;
    }
}

