/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks.bounds;

import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickSort {
    private static final Random RND = new Random();

    private static void swap(Object[] array, int i, int j) {
        Object tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static <E extends Comparable<? super E>> int partition(E[] array, int begin, int end) {
        int index = begin + RND.nextInt(end - begin + 1);
        E pivot = array[index];
        QuickSort.swap(array, index, end);
        for (int i = index = begin; i < end; ++i) {
            if (array[i].toString().length() < pivot.toString().length()) {
                QuickSort.swap(array, index++, i);
                continue;
            }
            if (array[i].toString().length() != pivot.toString().length() || array[i].compareTo(pivot) > 0) continue;
            QuickSort.swap(array, index++, i);
        }
        QuickSort.swap(array, index, end);
        return index;
    }

    private static <E extends Comparable<? super E>> void qsort(E[] array, int begin, int end) {
        if (end > begin) {
            int index = QuickSort.partition(array, (int)begin, (int)end);
            QuickSort.qsort(array, (int)begin, (int)(index - 1));
            QuickSort.qsort(array, (int)(index + 1), (int)end);
        }
    }

    public static <E extends Comparable<? super E>> void sort(E[] array) {
        QuickSort.qsort(array, (int)0, (int)(array.length - 1));
    }
}

