/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks;

import java.io.Serializable;
import org.modcs.tools.Util.Coeficient;
import org.modcs.tools.Util.CoeficientsOperation;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockChain;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.graphrbd.ConnectionBlock;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;

public class BlockParallel
extends BlockChain
implements Serializable {
    public BlockParallel(String name) {
        super(name);
    }

    public double calculateReliability(double time) {
        double reliabilityTemp = 1.0;
        if (time > 0.0) {
            for (int i = 0; i < this.blocks.size(); ++i) {
                reliabilityTemp *= 1.0 - ((Block)this.blocks.get(i)).calculateReliability(time);
            }
            return 1.0 - reliabilityTemp;
        }
        return 1.0;
    }

    public double calculateAvailability(double time) {
        double availabilityTemp = 1.0;
        if (time > 0.0) {
            for (int i = 0; i < this.blocks.size(); ++i) {
                availabilityTemp *= 1.0 - ((Block)this.blocks.get(i)).calculateAvailability(time);
            }
            return 1.0 - availabilityTemp;
        }
        return 1.0;
    }

    public int getLengthX() {
        int lengthX = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            lengthX = Math.max(((Block)this.blocks.get(i)).getLengthX(), lengthX);
        }
        return lengthX;
    }

    public int getLengthXPixels() {
        int lengthXPixels = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            lengthXPixels = Math.max(((Block)this.blocks.get(i)).getLengthXPixels(), lengthXPixels);
        }
        return lengthXPixels += 2 * GraphViewRBD.BLOCK_SEPARATION;
    }

    public int getLengthY() {
        int lengthY = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            lengthY += ((Block)this.blocks.get(i)).getLengthY();
        }
        return lengthY;
    }

    public int getLengthYPixels() {
        boolean lengthYPixels = false;
        return this.getMaxLengthYPixels() * this.blocks.size() + (this.blocks.size() - 1) * GraphViewRBD.BLOCK_SEPARATION;
    }

    public int getMaxLengthYPixels() {
        int lengthYPixels = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            lengthYPixels = Math.max(lengthYPixels, ((Block)this.blocks.get(i)).getLengthYPixels());
        }
        return lengthYPixels;
    }

    public ConnectionBlock drawBlock(int x, int y) {
        ConnectionBlock connectionBlock = GraphViewRBD.drawBeginEndOfBlock(this, x, y + GraphViewRBD.BLOCK_SIZE_Y / 2);
        if (this.blocks.size() % 2 == 0) {
            GraphViewRBD.drawEvenBlocksParallel(this, x, y, connectionBlock);
        } else {
            GraphViewRBD.drawOddBlocksParallel(this, x, y, connectionBlock);
        }
        return connectionBlock;
    }

    public double calculateMeanTimeToFailure() {
        double tempMTTF = 0.0;
        if (this.isBlockHasMaintainabilityEdited()) {
            tempMTTF = 1.0;
            double tempMTTR = 0.0;
            for (int i = 0; i < this.blocks.size(); ++i) {
                tempMTTF *= ((Block)this.blocks.get(i)).calculateMeanTimeToFailure();
                tempMTTR += ((Block)this.blocks.get(i)).calculateMeanTimeToRepair();
            }
            tempMTTF *= (double)this.blocks.size();
            tempMTTF /= tempMTTR;
        } else {
            int i;
            tempMTTF = ((Block)this.blocks.get(0)).calculateMeanTimeToFailure();
            if (this.blocks.size() == 1) {
                return tempMTTF;
            }
            boolean isEqual = true;
            for (i = 0; i < this.blocks.size(); ++i) {
                if (((Block)this.blocks.get(i)).calculateMeanTimeToFailure() == tempMTTF) continue;
                isEqual = false;
                i = this.blocks.size();
            }
            if (!isEqual) {
                for (i = 1; i < this.blocks.size(); ++i) {
                    if (this.blocks.size() - i > 1) {
                        tempMTTF = tempMTTF + ((Block)this.blocks.get(i)).calculateMeanTimeToFailure() + ((Block)this.blocks.get(i + 1)).calculateMeanTimeToFailure() - 1.0 / (1.0 / tempMTTF + 1.0 / ((Block)this.blocks.get(i)).calculateMeanTimeToFailure()) - 1.0 / (1.0 / tempMTTF + 1.0 / ((Block)this.blocks.get(i + 1)).calculateMeanTimeToFailure()) - 1.0 / (1.0 / ((Block)this.blocks.get(i)).calculateMeanTimeToFailure() + 1.0 / ((Block)this.blocks.get(i + 1)).calculateMeanTimeToFailure()) + 1.0 / (1.0 / tempMTTF + 1.0 / ((Block)this.blocks.get(i)).calculateMeanTimeToFailure() + 1.0 / ((Block)this.blocks.get(i + 1)).calculateMeanTimeToFailure());
                        ++i;
                        continue;
                    }
                    tempMTTF = tempMTTF + ((Block)this.blocks.get(i)).calculateMeanTimeToFailure() - 1.0 / (1.0 / tempMTTF + 1.0 / ((Block)this.blocks.get(i)).calculateMeanTimeToFailure());
                }
            } else {
                double partialMTTF = tempMTTF;
                for (int i2 = 1; i2 < this.blocks.size(); ++i2) {
                    tempMTTF += partialMTTF / (double)(i2 + 1);
                }
            }
        }
        return tempMTTF;
    }

    public void copy(Block block) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Coeficient[] getCoeficientsMeanTimeToFailure() {
        Coeficient[] temp = null;
        if (this.blocks.size() == 2) {
            temp = CoeficientsOperation.add(((Block)this.blocks.get(0)).getCoeficientsMeanTimeToFailure(), ((Block)this.blocks.get(1)).getCoeficientsMeanTimeToFailure());
            temp = CoeficientsOperation.add(temp, CoeficientsOperation.minus(CoeficientsOperation.multiply(((Block)this.blocks.get(0)).getCoeficientsMeanTimeToFailure(), ((Block)this.blocks.get(1)).getCoeficientsMeanTimeToFailure())));
        }
        return temp;
    }

    public MinimalPath[] getMinimalPaths() {
        MinimalPath[] minPaths = new MinimalPath[this.getNumberOfPaths()];
        int iterator = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (((Block)this.blocks.get(i)).getNumberOfPaths() == 1) {
                minPaths[iterator++] = ((Block)this.blocks.get(i)).getMinimalPaths()[0];
                continue;
            }
            int k = 0;
            while (k < ((Block)this.blocks.get(i)).getNumberOfPaths()) {
                minPaths[iterator++] = ((Block)this.blocks.get(i)).getMinimalPaths()[k++];
            }
        }
        return minPaths;
    }

    public int getNumberOfPaths() {
        int numberOfPaths = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            numberOfPaths += ((Block)this.blocks.get(i)).getNumberOfPaths();
        }
        return numberOfPaths;
    }

    public MinimalCut[] getMinimalCuts() {
        MinimalCut[] minCuts = new MinimalCut[this.getNumberOfCuts()];
        MinimalCut thisCut = new MinimalCut();
        if (minCuts.length == 1) {
            for (int i = 0; i < this.blocks.size(); ++i) {
                thisCut.append(((Block)this.blocks.get(i)).getMinimalCuts()[0]);
            }
            minCuts[0] = thisCut;
        } else {
            int i;
            int control = minCuts.length;
            for (i = 0; i < this.blocks.size(); ++i) {
                control /= ((Block)this.blocks.get(i)).getNumberOfCuts();
                if (((Block)this.blocks.get(i)).getNumberOfCuts() == 1) {
                    thisCut.append(((Block)this.blocks.get(i)).getMinimalCuts()[0]);
                    continue;
                }
                int j = 0;
                while (j < minCuts.length) {
                    for (int k = 0; k < ((Block)this.blocks.get(i)).getNumberOfCuts(); ++k) {
                        for (int z = 0; z < control; ++z) {
                            if (minCuts[j] == null) {
                                minCuts[j++] = ((Block)this.blocks.get(i)).getMinimalCuts()[k];
                                continue;
                            }
                            minCuts[j++].append(((Block)this.blocks.get(i)).getMinimalCuts()[k]);
                        }
                    }
                }
            }
            for (i = 0; i < minCuts.length; ++i) {
                minCuts[i].append(thisCut);
            }
            if (minCuts.length == 1) {
                minCuts[0] = thisCut;
            }
        }
        return minCuts;
    }

    public int getNumberOfCuts() {
        int numberOfCuts = 1;
        for (int i = 0; i < this.blocks.size(); ++i) {
            numberOfCuts *= ((Block)this.blocks.get(i)).getNumberOfCuts();
        }
        return numberOfCuts;
    }
}

