/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks;

import java.io.Serializable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.modcs.tools.Util.ApplicationMath;
import org.modcs.tools.Util.Coeficient;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.graphrbd.ConnectionBlock;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;

public class BlockKOutOfN
extends Block
implements Serializable {
    private int n;
    private int k;
    private BlockExponential block;
    private int indexOfBlock;

    public BlockKOutOfN(String name, int n, int k, BlockExponential block, int indexOfBlock) {
        super(name);
        this.indexOfBlock = indexOfBlock;
        if (n >= k && n != 0 && k != 0) {
            this.n = n;
            this.k = k;
        } else {
            System.out.println("K-OUT-OF-N ERROR");
        }
        if (block != null) {
            this.block = block;
        } else {
            System.out.println("NULL POINTER");
        }
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(BlockExponential block) {
        if (this.block != null) {
            block.setFatherBlock(this);
            this.block = block;
        }
    }

    private double calculateBinomialProbability(double probability, int x) {
        return (double)ApplicationMath.calculateCombination(this.n, x) * Math.pow(probability, x) * Math.pow(1.0 - probability, this.n - x);
    }

    public double calculateReliability(double time) {
        if (this.block.getState().equals("DEFAULT")) {
            double reliabilityTemp = 0.0;
            for (int i = this.k; i <= this.n; ++i) {
                reliabilityTemp += this.calculateBinomialProbability(this.block.calculateReliability(time), i);
            }
            return reliabilityTemp;
        }
        if (this.block.getState().equals("WORKING")) {
            return 1.0;
        }
        return 0.0;
    }

    public double calculateAvailability(double time) {
        double availabilityTemp = 0.0;
        for (int i = this.k; i <= this.n; ++i) {
            availabilityTemp += this.calculateBinomialProbability(this.block.calculateAvailability(time), i);
        }
        return availabilityTemp;
    }

    public void updateJTree(DefaultMutableTreeNode nodeTree) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(this);
        nodeTree.add(newNode);
        this.block.updateJTree(newNode);
    }

    public int getLengthX() {
        return this.block.getLengthX();
    }

    public int getLengthXPixels() {
        return this.block.getLengthXPixels();
    }

    public int getLengthYPixels() {
        return this.block.getLengthYPixels();
    }

    public int getLengthY() {
        return this.block.getLengthY();
    }

    public ConnectionBlock drawBlock(int x, int y) {
        this.block.setName(this.toString());
        return GraphViewRBD.drawBlock(this, x, y);
    }

    public double calculateMeanTimeToFailure() {
        double tempMTTF = 0.0;
        tempMTTF = this.block.calculateMeanTimeToFailure();
        for (int i = this.k; i <= this.n; ++i) {
            tempMTTF += (double)(1 / i);
        }
        return tempMTTF;
    }

    public boolean isBlockHasReliabilityEdited() {
        return this.block.isBlockHasReliabilityEdited();
    }

    public boolean isBlockHasMaintainabilityEdited() {
        return this.block.isBlockHasMaintainabilityEdited();
    }

    public String toString() {
        return "b" + this.indexOfBlock + " " + this.k + "/" + this.n;
    }

    public void copy(Block block) {
        if (block instanceof BlockKOutOfN) {
            this.block = ((BlockKOutOfN)block).block;
            this.fatherBlock = block.getFatherBlock();
            this.indexOfBlock = ((BlockKOutOfN)block).indexOfBlock;
            this.k = ((BlockKOutOfN)block).k;
            this.n = ((BlockKOutOfN)block).n;
            this.name = block.name;
        }
    }

    public double calculateMeanTimeToRepair() {
        return (double)this.n * this.block.calculateMeanTimeToRepair() * (1.0 / this.block.calculateMeanTimeToFailure());
    }

    public Coeficient[] getCoeficientsMeanTimeToFailure() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MinimalPath[] getMinimalPaths() {
        MinimalPath[] minPaths = new MinimalPath[1];
        MinimalPath thisPath = new MinimalPath();
        thisPath.add(this);
        minPaths[0] = thisPath;
        return minPaths;
    }

    public int getNumberOfPaths() {
        return 1;
    }

    public MinimalCut[] getMinimalCuts() {
        MinimalCut[] minCuts = new MinimalCut[1];
        MinimalCut thisCut = new MinimalCut();
        thisCut.add(this);
        minCuts[0] = thisCut;
        return minCuts;
    }

    public int getNumberOfCuts() {
        return 1;
    }
}

