/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.modcs.tools.Util.Coeficient;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockChain;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.blocks.BlockParallel;
import org.modcs.tools.rbd.blocks.BlockSeries;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.evaluatorrbd.RBDLabel;
import org.modcs.tools.rbd.graphrbd.ConnectionBlock;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockBridge
extends Block
implements Serializable {
    private ArrayList<Block> blocks = new ArrayList();
    private static int BLOCK_BRIDGE_NUMBER_OF_ELEMENTS = 5;
    public static int INDEX_LEFT_UP_BLOCK = 0;
    public static int INDEX_RIGHT_UP_BLOCK = 1;
    public static int INDEX_LEFT_BOTTOM_BLOCK = 2;
    public static int INDEX_RIGHT_BOTTOM_BLOCK = 3;
    public static int INDEX_CENTRAL_BLOCK = 4;

    public BlockBridge(String name, int indexName, double failureRate, double repairRate, RBDLabel labelFailure, RBDLabel labelRepairRate) {
        super(name);
        this.initArrayList(BLOCK_BRIDGE_NUMBER_OF_ELEMENTS);
        BlockExponential block = new BlockExponential("b" + (indexName + 2), failureRate, repairRate, labelFailure, labelRepairRate);
        this.setCentralBlock(block);
        block.setFatherBlock(this);
        block = new BlockExponential("b" + (indexName + 3), failureRate, repairRate, labelFailure, labelRepairRate);
        this.setLeftBottomBlock(block);
        block.setFatherBlock(this);
        block = new BlockExponential("b" + indexName, failureRate, repairRate, labelFailure, labelRepairRate);
        this.setLeftUpBlock(block);
        block.setFatherBlock(this);
        block = new BlockExponential("b" + (indexName + 4), failureRate, repairRate, labelFailure, labelRepairRate);
        this.setRightBottomBlock(block);
        block.setFatherBlock(this);
        block = new BlockExponential("b" + (indexName + 1), failureRate, repairRate, labelFailure, labelRepairRate);
        this.setRightUpBlock(block);
        block.setFatherBlock(this);
    }

    public BlockBridge(String name, int indexName, RBDLabel labelFailure, RBDLabel labelRepairRate) {
        this(name, indexName, 0.0, 0.0, labelFailure, labelRepairRate);
    }

    private void initArrayList(int numberOfElements) {
        for (int i = 0; i < numberOfElements; ++i) {
            this.blocks.add(null);
        }
    }

    public ArrayList<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<Block> val) {
        this.blocks = val;
    }

    public void setLeftUpBlock(Block block) {
        if (block != null) {
            this.blocks.set(INDEX_LEFT_UP_BLOCK, block);
        } else {
            System.out.println("NULL POINTER");
        }
    }

    public void setRightUpBlock(Block block) {
        if (block != null) {
            this.blocks.set(INDEX_RIGHT_UP_BLOCK, block);
        } else {
            System.out.println("NULL POINTER");
        }
    }

    public void setLeftBottomBlock(Block block) {
        if (block != null) {
            this.blocks.set(INDEX_LEFT_BOTTOM_BLOCK, block);
        } else {
            System.out.println("NULL POINTER");
        }
    }

    public void setRightBottomBlock(Block block) {
        if (block != null) {
            this.blocks.set(INDEX_RIGHT_BOTTOM_BLOCK, block);
        } else {
            System.out.println("NULL POINTER");
        }
    }

    public void setCentralBlock(Block block) {
        if (block != null) {
            this.blocks.set(INDEX_CENTRAL_BLOCK, block);
        } else {
            System.out.println("NULL POINTER");
        }
    }

    private double calculateReliabilityCentralBlockWorking(double time) {
        BlockSeries blockSeriesTemp = new BlockSeries(null);
        BlockParallel blockParallelLeft = new BlockParallel(null);
        blockParallelLeft.addBlock(this.blocks.get(INDEX_LEFT_UP_BLOCK));
        blockParallelLeft.addBlock(this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK));
        BlockParallel blockParallelRight = new BlockParallel(null);
        blockParallelRight.addBlock(this.blocks.get(INDEX_RIGHT_UP_BLOCK));
        blockParallelRight.addBlock(this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK));
        blockSeriesTemp.addBlock(blockParallelLeft);
        blockSeriesTemp.addBlock(blockParallelRight);
        double reliabilityCentralBlockWorking = ((BlockChain)blockSeriesTemp).calculateReliability(time) * this.blocks.get(INDEX_CENTRAL_BLOCK).calculateReliability(time);
        return reliabilityCentralBlockWorking;
    }

    private double calculateReliabilityCentralBlockNotWorking(double time) {
        BlockParallel blockParallelTemp = new BlockParallel(null);
        BlockSeries blockSeriesUp = new BlockSeries(null);
        blockSeriesUp.addBlock(this.blocks.get(INDEX_LEFT_UP_BLOCK));
        blockSeriesUp.addBlock(this.blocks.get(INDEX_RIGHT_UP_BLOCK));
        BlockSeries blockSeriesDown = new BlockSeries(null);
        blockSeriesDown.addBlock(this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK));
        blockSeriesDown.addBlock(this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK));
        blockParallelTemp.addBlock(blockSeriesUp);
        blockParallelTemp.addBlock(blockSeriesDown);
        double reliabilityCentralBlockNotWorking = ((BlockChain)blockParallelTemp).calculateReliability(time) * (1.0 - this.blocks.get(INDEX_CENTRAL_BLOCK).calculateReliability(time));
        return reliabilityCentralBlockNotWorking;
    }

    private double calculateAvailabilityCentralBlockWorking(double time) {
        BlockSeries blockSeriesTemp = new BlockSeries(null);
        BlockParallel blockParallelLeft = new BlockParallel(null);
        blockParallelLeft.addBlock(this.blocks.get(INDEX_LEFT_UP_BLOCK));
        blockParallelLeft.addBlock(this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK));
        BlockParallel blockParallelRight = new BlockParallel(null);
        blockParallelRight.addBlock(this.blocks.get(INDEX_RIGHT_UP_BLOCK));
        blockParallelRight.addBlock(this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK));
        blockSeriesTemp.addBlock(blockParallelLeft);
        blockSeriesTemp.addBlock(blockParallelRight);
        double availabilityCentralBlockWorking = ((BlockChain)blockSeriesTemp).calculateAvailability(time) * this.blocks.get(INDEX_CENTRAL_BLOCK).calculateAvailability(time);
        return availabilityCentralBlockWorking;
    }

    private double calculateAvailabilityCentralBlockNotWorking(double time) {
        BlockParallel blockParallelTemp = new BlockParallel(null);
        BlockSeries blockSeriesUp = new BlockSeries(null);
        blockSeriesUp.addBlock(this.blocks.get(INDEX_LEFT_UP_BLOCK));
        blockSeriesUp.addBlock(this.blocks.get(INDEX_RIGHT_UP_BLOCK));
        BlockSeries blockSeriesDown = new BlockSeries(null);
        blockSeriesDown.addBlock(this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK));
        blockSeriesDown.addBlock(this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK));
        blockParallelTemp.addBlock(blockSeriesUp);
        blockParallelTemp.addBlock(blockSeriesDown);
        double availabilityCentralBlockNotWorking = ((BlockChain)blockParallelTemp).calculateAvailability(time) * (1.0 - this.blocks.get(INDEX_CENTRAL_BLOCK).calculateAvailability(time));
        return availabilityCentralBlockNotWorking;
    }

    @Override
    public double calculateReliability(double time) {
        return this.calculateReliabilityCentralBlockNotWorking(time) + this.calculateReliabilityCentralBlockWorking(time);
    }

    @Override
    public double calculateAvailability(double time) {
        return this.calculateAvailabilityCentralBlockNotWorking(time) + this.calculateAvailabilityCentralBlockWorking(time);
    }

    @Override
    public void updateJTree(DefaultMutableTreeNode nodeTree) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(this);
        nodeTree.add(newNode);
        for (int i = 0; i < this.blocks.size(); ++i) {
            this.blocks.get(i).updateJTree(newNode);
        }
    }

    @Override
    public int getLengthX() {
        int lengthX = 0;
        lengthX = Math.max(this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).getLengthX(), this.blocks.get(INDEX_LEFT_UP_BLOCK).getLengthX());
        lengthX += this.blocks.get(INDEX_CENTRAL_BLOCK).getLengthX();
        return lengthX += Math.max(this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).getLengthX(), this.blocks.get(INDEX_RIGHT_UP_BLOCK).getLengthX());
    }

    @Override
    public int getLengthXPixels() {
        int lengthXPixels = 0;
        lengthXPixels += GraphViewRBD.BLOCK_SEPARATION;
        lengthXPixels += Math.max(this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).getLengthXPixels(), this.blocks.get(INDEX_LEFT_UP_BLOCK).getLengthXPixels());
        lengthXPixels += GraphViewRBD.BLOCK_SEPARATION;
        lengthXPixels += this.blocks.get(INDEX_CENTRAL_BLOCK).getLengthXPixels();
        lengthXPixels += GraphViewRBD.BLOCK_SEPARATION;
        lengthXPixels += Math.max(this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).getLengthXPixels(), this.blocks.get(INDEX_RIGHT_UP_BLOCK).getLengthXPixels());
        return lengthXPixels += GraphViewRBD.BLOCK_SEPARATION;
    }

    @Override
    public int getLengthYPixels() {
        int lengthYPixels = 0;
        lengthYPixels = Math.max(this.blocks.get(INDEX_LEFT_UP_BLOCK).getLengthYPixels(), this.blocks.get(INDEX_RIGHT_UP_BLOCK).getLengthYPixels());
        lengthYPixels += GraphViewRBD.BLOCK_SEPARATION;
        lengthYPixels += this.blocks.get(INDEX_CENTRAL_BLOCK).getLengthYPixels();
        lengthYPixels += GraphViewRBD.BLOCK_SEPARATION;
        return lengthYPixels += Math.max(this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).getLengthYPixels(), this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).getLengthYPixels());
    }

    @Override
    public int getLengthY() {
        int lengthY = 0;
        lengthY = Math.max(this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).getLengthY(), this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).getLengthY());
        lengthY += this.blocks.get(INDEX_CENTRAL_BLOCK).getLengthY();
        lengthY = Math.max(this.blocks.get(INDEX_LEFT_UP_BLOCK).getLengthY(), this.blocks.get(INDEX_RIGHT_UP_BLOCK).getLengthY());
        return lengthY;
    }

    @Override
    public ConnectionBlock drawBlock(int x, int y) {
        ConnectionBlock connectionBlock = GraphViewRBD.drawBeginEndOfBlock(this, x, y + GraphViewRBD.BLOCK_SIZE_Y / 2);
        GraphViewRBD.drawBlockBridge(this, x, y + GraphViewRBD.BLOCK_SIZE_Y / 2, connectionBlock);
        return connectionBlock;
    }

    @Override
    public double calculateMeanTimeToFailure() {
        double mttfTemp = 0.0;
        mttfTemp = 1.0 / (1.0 / this.blocks.get(INDEX_LEFT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_UP_BLOCK).calculateMeanTimeToFailure());
        mttfTemp += 1.0 / (1.0 / this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).calculateMeanTimeToFailure());
        mttfTemp += 1.0 / (1.0 / this.blocks.get(INDEX_LEFT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_CENTRAL_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).calculateMeanTimeToFailure());
        mttfTemp += 1.0 / (1.0 / this.blocks.get(INDEX_RIGHT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_CENTRAL_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).calculateMeanTimeToFailure());
        mttfTemp -= 1.0 / (1.0 / this.blocks.get(INDEX_LEFT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_CENTRAL_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).calculateMeanTimeToFailure());
        mttfTemp -= 1.0 / (1.0 / this.blocks.get(INDEX_RIGHT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_CENTRAL_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).calculateMeanTimeToFailure());
        mttfTemp -= 1.0 / (1.0 / this.blocks.get(INDEX_LEFT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_CENTRAL_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).calculateMeanTimeToFailure());
        mttfTemp -= 1.0 / (1.0 / this.blocks.get(INDEX_LEFT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_CENTRAL_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).calculateMeanTimeToFailure());
        mttfTemp -= 1.0 / (1.0 / this.blocks.get(INDEX_LEFT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).calculateMeanTimeToFailure());
        return mttfTemp += 2.0 / (1.0 / this.blocks.get(INDEX_LEFT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_UP_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_CENTRAL_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).calculateMeanTimeToFailure() + 1.0 / this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).calculateMeanTimeToFailure());
    }

    @Override
    public boolean isBlockHasReliabilityEdited() {
        return this.blocks.get(INDEX_LEFT_UP_BLOCK).isBlockHasReliabilityEdited() && this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).isBlockHasReliabilityEdited() && this.blocks.get(INDEX_RIGHT_UP_BLOCK).isBlockHasReliabilityEdited() && this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).isBlockHasReliabilityEdited() && this.blocks.get(INDEX_CENTRAL_BLOCK).isBlockHasReliabilityEdited();
    }

    @Override
    public boolean isBlockHasMaintainabilityEdited() {
        return this.blocks.get(INDEX_LEFT_UP_BLOCK).isBlockHasMaintainabilityEdited() && this.blocks.get(INDEX_LEFT_BOTTOM_BLOCK).isBlockHasMaintainabilityEdited() && this.blocks.get(INDEX_RIGHT_UP_BLOCK).isBlockHasMaintainabilityEdited() && this.blocks.get(INDEX_RIGHT_BOTTOM_BLOCK).isBlockHasMaintainabilityEdited() && this.blocks.get(INDEX_CENTRAL_BLOCK).isBlockHasMaintainabilityEdited();
    }

    @Override
    public void copy(Block block) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double calculateMeanTimeToRepair() {
        double tempMTTR = 0.0;
        double sumOfFailureRate = 0.0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            tempMTTR += this.blocks.get(i).calculateMeanTimeToRepair() * (1.0 / this.blocks.get(i).calculateMeanTimeToFailure());
            sumOfFailureRate += 1.0 / this.blocks.get(i).calculateMeanTimeToFailure();
        }
        return tempMTTR / sumOfFailureRate;
    }

    @Override
    public Coeficient[] getCoeficientsMeanTimeToFailure() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MinimalPath[] getMinimalPaths() {
        MinimalPath[] minPaths = new MinimalPath[this.getNumberOfPaths()];
        minPaths[0] = this.getBlocks().get(0).getMinimalPaths()[0];
        minPaths[0].add((BlockExponential)this.getBlocks().get(1));
        minPaths[1] = this.getBlocks().get(2).getMinimalPaths()[0];
        minPaths[1].add((BlockExponential)this.getBlocks().get(3));
        minPaths[2] = this.getBlocks().get(1).getMinimalPaths()[0];
        minPaths[2].add((BlockExponential)this.getBlocks().get(4));
        minPaths[2].add((BlockExponential)this.getBlocks().get(2));
        minPaths[3] = this.getBlocks().get(0).getMinimalPaths()[0];
        minPaths[3].add((BlockExponential)this.getBlocks().get(4));
        minPaths[3].add((BlockExponential)this.getBlocks().get(3));
        return minPaths;
    }

    @Override
    public int getNumberOfPaths() {
        return 4;
    }

    @Override
    public MinimalCut[] getMinimalCuts() {
        MinimalCut[] minCuts = new MinimalCut[this.getNumberOfCuts()];
        minCuts[0] = this.getBlocks().get(0).getMinimalCuts()[0];
        minCuts[0].add((BlockExponential)this.getBlocks().get(2));
        minCuts[1] = this.getBlocks().get(1).getMinimalCuts()[0];
        minCuts[1].add((BlockExponential)this.getBlocks().get(3));
        minCuts[2] = this.getBlocks().get(1).getMinimalCuts()[0];
        minCuts[2].add((BlockExponential)this.getBlocks().get(4));
        minCuts[2].add((BlockExponential)this.getBlocks().get(2));
        minCuts[3] = this.getBlocks().get(0).getMinimalCuts()[0];
        minCuts[3].add((BlockExponential)this.getBlocks().get(4));
        minCuts[3].add((BlockExponential)this.getBlocks().get(3));
        return minCuts;
    }

    @Override
    public int getNumberOfCuts() {
        return 4;
    }
}

