/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.Util;

import java.awt.BorderLayout;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class Util {
    public static long factorial(long n) {
        if (n < 0L) {
            throw new RuntimeException("Underflow error in factorial");
        }
        if (n > 20L) {
            throw new RuntimeException("Overflow error in factorial");
        }
        if (n == 0L) {
            return 1L;
        }
        return n * Util.factorial(n - 1L);
    }

    public static double logGamma(double x) {
        double[] coef = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};
        double step = 2.50662827465;
        double fpf = 5.5;
        double t = x - 1.0;
        double tmp = t + fpf;
        tmp = (t + 0.5) * Math.log(tmp) - tmp;
        double ser = 1.0;
        for (int i = 1; i <= 6; ++i) {
            ser += coef[i - 1] / (t += 1.0);
        }
        return tmp + Math.log(step * ser);
    }

    public static boolean checkParentheses(String text) {
        int countOpen = 0;
        int countClose = 0;
        char[] array = text.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == '(') {
                ++countOpen;
            } else if (array[i] == ')') {
                ++countClose;
            }
            if (countClose <= countOpen) continue;
            return false;
        }
        return countClose == countOpen;
    }

    public static String removeEndComand(String text) {
        if (text != null) {
            if (text.charAt(text.length() - 1) == ';') {
                text = text.substring(0, text.length() - 1);
            }
            return text.trim();
        }
        return "";
    }

    public static boolean isDouble(String doubleValue) {
        try {
            Double.parseDouble(doubleValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ImageIcon resizeImage(ImageIcon icon, int maxSize) {
        Image newimg = null;
        Image img = icon.getImage();
        if (icon.getIconWidth() > icon.getIconHeight()) {
            double ratio = (double)icon.getIconHeight() / (double)icon.getIconWidth();
            int newWidth = maxSize;
            newimg = img.getScaledInstance(newWidth, (int)((double)newWidth * ratio), 4);
        } else {
            double ratio = (double)icon.getIconWidth() / (double)icon.getIconHeight();
            int newHeight = maxSize;
            newimg = img.getScaledInstance((int)((double)newHeight * ratio), newHeight, 4);
        }
        icon = new ImageIcon(newimg);
        return icon;
    }

    public static void refreshScreen(JPanel jpanel, JPanel template) {
        jpanel.setPreferredSize(template.getPreferredSize());
        template.removeAll();
        template.setLayout(new BorderLayout());
        template.add(jpanel);
        template.updateUI();
    }

    public static double numberOfNines(double reliabilityValue) {
        return 2.0 - Math.log10(100.0 - reliabilityValue * 100.0);
    }
}

