/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.sustainability;

import com.hp.desdac.powerstructure.gui.graphview.ArrowGraphicalElement;
import com.hp.desdac.powerstructure.gui.graphview.ComponentGraphicalElement;
import com.hp.desdac.powerstructure.gui.graphview.GraphEdXPowerDataCenter;
import com.hp.desdac.powerstructure.gui.graphview.GraphicalConnectionDataCenter;
import com.hp.desdac.powerstructure.translate.LoopDetectedException;
import com.hp.desdac.sustainability.SustainabilityComponent;
import com.local.entities.ProjectDesdac;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationalExergy
extends SustainabilityComponent {
    private ProjectDesdac projectDesdac;
    private double systemInputPower = 0.0;

    public double getSystemInputPower() {
        return this.systemInputPower;
    }

    public OperationalExergy(double ambTemp, double compTemp, double systemOutputPower, int lifeTime, double deliEff, double availability, ProjectDesdac projectDesdac) {
        super(ambTemp, compTemp, systemOutputPower, lifeTime, deliEff, availability);
        this.projectDesdac = projectDesdac;
    }

    public double computeOperationalExergy() {
        double in = this.computeInputPower();
        double out = this.getSystemOutputPower();
        double ef = out / in;
        double operationalExergy = (this.getAmbTemp() + 273.15) / (this.getCompTemp() + 273.15) * (1.0 - ef) * out * (double)this.getLifeTime() * this.getAvailability() * 3.6 / 1000.0;
        return operationalExergy;
    }

    public double computeInputPower() {
        double in = 0.0;
        try {
            GraphEdXPowerDataCenter graphEdXDataCenter = this.projectDesdac.getAppPowerStructure().getGraphViewDataCenter().getApp();
            GraphicalConnectionDataCenter graphicalConnectionDataCenter = GraphicalConnectionDataCenter.createGraphicalConnectionDataCenter(graphEdXDataCenter);
            ArrayList<ComponentGraphicalElement> leafComponents = this.getLeafComponents(graphicalConnectionDataCenter);
            if (leafComponents.size() > 1) {
                JOptionPane.showMessageDialog(null, "You should consider only one endPoint.");
            } else {
                in = this.createPath(graphicalConnectionDataCenter, leafComponents.get(0));
            }
            return in;
        }
        catch (LoopDetectedException ex) {
            Logger.getLogger(OperationalExergy.class.getName()).log(Level.SEVERE, null, ex);
            return in;
        }
    }

    private double createPath(GraphicalConnectionDataCenter graphicalConnectionDataCenter, ComponentGraphicalElement componentGraphicalElement) throws LoopDetectedException {
        ArrayList<ComponentGraphicalElement> parentsComponents = this.getComponentParents(graphicalConnectionDataCenter, componentGraphicalElement);
        SustainabilityComponent currentComponent = componentGraphicalElement.getDataCenterComponent().getSustainabilityComponent();
        if (currentComponent.getOutputPower() == 0.0) {
            currentComponent.setOutputPower(this.getSystemOutputPower());
        }
        ArrayList<Double> weights = this.getEdgeWeights(graphicalConnectionDataCenter, componentGraphicalElement);
        if (parentsComponents.size() == 0) {
            double input;
            double realPower = 0.0;
            realPower = input = currentComponent.getOutputPower();
            this.systemInputPower = this.systemInputPower != 0.0 ? (this.systemInputPower += realPower) : realPower;
            return this.systemInputPower;
        }
        if (parentsComponents.size() == 1) {
            SustainabilityComponent parentComponent = parentsComponents.get(0).getDataCenterComponent().getSustainabilityComponent();
            double realPower = 0.0;
            double weight = 0.0;
            double input = currentComponent.getOutputPower();
            weight = weights.get(0);
            realPower = input * weight;
            parentComponent.setInputPower(realPower);
            parentComponent.setOutputPower(realPower / parentComponent.getDeliEff() * 100.0);
            this.createPath(graphicalConnectionDataCenter, parentsComponents.get(0));
            return this.systemInputPower;
        }
        if (parentsComponents.size() >= 1) {
            for (int i = 0; i < parentsComponents.size(); ++i) {
                SustainabilityComponent parentComponent = parentsComponents.get(i).getDataCenterComponent().getSustainabilityComponent();
                double realPower = 0.0;
                double weight = 0.0;
                double input = currentComponent.getOutputPower();
                weight = weights.get(i);
                realPower = input * weight;
                parentComponent.setInputPower(realPower);
                parentComponent.setOutputPower(realPower / parentComponent.getDeliEff() * 100.0);
                this.createPath(graphicalConnectionDataCenter, parentsComponents.get(i));
            }
        }
        return this.systemInputPower;
    }

    protected ArrayList<Double> getEdgeWeights(GraphicalConnectionDataCenter graphicalConnectionDataCenter, ComponentGraphicalElement componentGraphicalElement) {
        ArrayList<ArrowGraphicalElement> arrowGraphicalElements = graphicalConnectionDataCenter.getArrowGraphicalElements();
        ArrayList<Double> weights = new ArrayList<Double>();
        for (int i = 0; i < arrowGraphicalElements.size(); ++i) {
            ArrowGraphicalElement arrowGraphicalElement = arrowGraphicalElements.get(i);
            if (!arrowGraphicalElement.getComponentTarget().equals(componentGraphicalElement) || !this.thereIsPath(arrowGraphicalElements, arrowGraphicalElement.getComponentSource())) continue;
            weights.add(arrowGraphicalElement.getDataCenterArc().getWeight());
        }
        return weights;
    }
}

