/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.sustainability;

import com.hp.desdac.powerstructure.entities.DataCenterComponent;
import com.hp.desdac.powerstructure.gui.graphview.ComponentGraphicalElement;
import com.hp.desdac.powerstructure.gui.graphview.GraphEdXPowerDataCenter;
import com.hp.desdac.powerstructure.gui.graphview.GraphicalConnectionDataCenter;
import com.hp.desdac.sustainability.SustainabilityComponent;
import com.local.entities.ProjectDesdac;
import java.util.ArrayList;

public class EmbeddedExergy
extends SustainabilityComponent {
    private ProjectDesdac projectDesdac;

    public EmbeddedExergy(double MSLE, double FWR, ProjectDesdac projectDesdac) {
        super(MSLE, FWR);
        this.projectDesdac = projectDesdac;
    }

    public EmbeddedExergy(double maxPower, double MSLE, double FWR, double ambTemp, double compTemp, int outputPower, int lifeTime, double deliEff, double availability) {
        super(maxPower, MSLE, FWR, ambTemp, compTemp, outputPower, lifeTime, deliEff, deliEff, availability, availability);
    }

    public EmbeddedExergy(double maxPower, double MSLE, double FWR, double ambTemp, double compTemp, int outputPower, int lifeTime, double deliEff, double availability, ProjectDesdac projectDesdac) {
        super(maxPower, MSLE, FWR, ambTemp, compTemp, outputPower, lifeTime, deliEff, deliEff, availability, availability);
        this.projectDesdac = projectDesdac;
    }

    public double computeEmbeddedExergy() {
        double embeddedExergy = this.SumEmbeddedEnergy() * (this.getMSLE() + (1.0 - this.getMSLE()) * (1.0 - this.getFWR() / 100.0));
        return embeddedExergy;
    }

    public double SumEmbeddedEnergy() {
        GraphicalConnectionDataCenter graphicalConnectionDataCenter = new GraphicalConnectionDataCenter();
        GraphEdXPowerDataCenter graphEdXDataCenter = this.projectDesdac.getAppPowerStructure().getGraphViewDataCenter().getApp();
        graphicalConnectionDataCenter = this.allElements(graphEdXDataCenter);
        ArrayList<ComponentGraphicalElement> elements = graphicalConnectionDataCenter.getComponentGraphicalElements();
        double sum = 0.0;
        for (int i = 0; i < elements.size(); ++i) {
            ComponentGraphicalElement defaultElement;
            Object object = elements.get(i);
            if (object == null || !(object instanceof ComponentGraphicalElement) || !((object = (defaultElement = object).getDataCenterComponent()) instanceof DataCenterComponent)) continue;
            DataCenterComponent dataCenterComponent = (DataCenterComponent)object;
            sum += dataCenterComponent.getSustainabilityComponent().getEmbeddedEnergy();
        }
        return sum;
    }
}

