/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.powerstructure.translate;

import com.hp.desdac.powerstructure.entities.ApplicationPowerStructure;
import com.hp.desdac.powerstructure.gui.graphview.ArrowGraphicalElement;
import com.hp.desdac.powerstructure.gui.graphview.ComponentGraphicalElement;
import com.hp.desdac.powerstructure.gui.graphview.GraphEdXPowerDataCenter;
import com.hp.desdac.powerstructure.gui.graphview.GraphicalConnectionDataCenter;
import com.hp.desdac.powerstructure.translate.DuplicatedEventException;
import com.hp.desdac.powerstructure.translate.LoopDetectedException;
import com.local.entities.ProjectDesdac;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockChain;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.blocks.BlockParallel;
import org.modcs.tools.rbd.blocks.BlockSeries;
import org.modcs.tools.rbd.blocks.RBDModel;
import org.modcs.tools.rbd.evaluatorrbd.ApplicationRBD;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;
import org.modcs.tools.spn.gui.graphview.GraphEdX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineDataCenterConvert {
    ArrayList<String> stringComponentNames;

    protected ArrayList<ComponentGraphicalElement> getComponentParents(GraphicalConnectionDataCenter graphicalConnectionDataCenter, ComponentGraphicalElement componentGraphicalElement) {
        ArrayList<ComponentGraphicalElement> componentGraphicalElements = new ArrayList<ComponentGraphicalElement>();
        ArrayList<ArrowGraphicalElement> arrowGraphicalElements = graphicalConnectionDataCenter.getArrowGraphicalElements();
        for (int i = 0; i < arrowGraphicalElements.size(); ++i) {
            ArrowGraphicalElement arrowGraphicalElement = arrowGraphicalElements.get(i);
            if (!arrowGraphicalElement.getComponentTarget().equals(componentGraphicalElement) || !this.thereIsPath(arrowGraphicalElements, arrowGraphicalElement.getComponentSource())) continue;
            componentGraphicalElements.add(arrowGraphicalElement.getComponentSource());
        }
        return componentGraphicalElements;
    }

    private boolean isLeaf(GraphicalConnectionDataCenter graphicalConnectionDataCenter, ComponentGraphicalElement componentGraphicalElement) {
        boolean result = true;
        ArrayList<ArrowGraphicalElement> arrowGraphicalElements = graphicalConnectionDataCenter.getArrowGraphicalElements();
        for (int i = 0; i < arrowGraphicalElements.size(); ++i) {
            ArrowGraphicalElement arrowGraphicalElement = arrowGraphicalElements.get(i);
            if (!arrowGraphicalElement.getComponentSource().equals(componentGraphicalElement) && componentGraphicalElement.getDataCenterComponent().getName().startsWith("TargetPoint")) continue;
            result = false;
            break;
        }
        return result;
    }

    public ArrayList<ComponentGraphicalElement> getLeafComponents(GraphicalConnectionDataCenter graphicalConnectionDataCenter) {
        ArrayList<ComponentGraphicalElement> leafComponents = new ArrayList<ComponentGraphicalElement>();
        ArrayList<ComponentGraphicalElement> componentGraphicalElements = graphicalConnectionDataCenter.getComponentGraphicalElements();
        for (int i = 0; i < componentGraphicalElements.size(); ++i) {
            ComponentGraphicalElement componentGraphicalElement = componentGraphicalElements.get(i);
            if (!this.isLeaf(graphicalConnectionDataCenter, componentGraphicalElement)) continue;
            leafComponents.add(componentGraphicalElement);
        }
        return leafComponents;
    }

    public boolean thereIsPath(ArrayList<ArrowGraphicalElement> arrowGraphicalElements, ComponentGraphicalElement componentGraphicalElement) {
        int i;
        boolean result = false;
        ArrayList<ComponentGraphicalElement> parents = new ArrayList<ComponentGraphicalElement>();
        for (i = 0; i < arrowGraphicalElements.size(); ++i) {
            ArrowGraphicalElement element = arrowGraphicalElements.get(i);
            if (!componentGraphicalElement.equals(element.getComponentTarget()) || element.getComponentSource() == null) continue;
            parents.add(element.getComponentSource());
        }
        for (i = 0; i < parents.size(); ++i) {
            ComponentGraphicalElement parentActual = (ComponentGraphicalElement)parents.get(i);
            boolean parentIsSourcePoint = parentActual.getDataCenterComponent().getName().toLowerCase().startsWith("SourcePoint".toLowerCase());
            if (!parentIsSourcePoint && !this.thereIsPath(arrowGraphicalElements, parentActual)) continue;
            result = true;
            break;
        }
        return result;
    }

    public RBDModel createRBDModel(ApplicationPowerStructure applicationPowerStructure) throws LoopDetectedException {
        this.stringComponentNames = new ArrayList();
        GraphEdXPowerDataCenter graphEdXDataCenter = applicationPowerStructure.getGraphViewDataCenter().getApp();
        GraphicalConnectionDataCenter graphicalConnectionDataCenter = GraphicalConnectionDataCenter.createGraphicalConnectionDataCenter(graphEdXDataCenter);
        ArrayList<ComponentGraphicalElement> leafComponents = this.getLeafComponents(graphicalConnectionDataCenter);
        RBDModel rbdModel = new RBDModel("Teste");
        if (leafComponents.size() > 1) {
            BlockParallel blockParallel = new BlockParallel("");
            rbdModel.incrementIndexOfBlocks();
            rbdModel.setModel(blockParallel);
            for (int i = 0; i < leafComponents.size(); ++i) {
                BlockSeries newBlockSeries = new BlockSeries("");
                newBlockSeries = (BlockSeries)this.createPath(graphicalConnectionDataCenter, leafComponents.get(i), rbdModel, newBlockSeries);
                blockParallel.addBlock(newBlockSeries);
            }
        } else {
            BlockSeries newBlockSeries = new BlockSeries("");
            newBlockSeries = (BlockSeries)this.createPath(graphicalConnectionDataCenter, leafComponents.get(0), rbdModel, newBlockSeries);
            rbdModel.incrementIndexOfBlocks();
            rbdModel.setModel(newBlockSeries);
        }
        return rbdModel;
    }

    public boolean testExist(ArrayList<String> strings, String string) {
        return strings.contains(string);
    }

    public boolean testDuplicatedComponents() {
        boolean result = false;
        int size = this.stringComponentNames.size();
        for (int i = 0; i < size; ++i) {
            String string = this.stringComponentNames.remove(0);
            if (!this.testExist(this.stringComponentNames, string)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void performAnalisysRBD(ProjectDesdac projectDesdac, ApplicationPowerStructure applicationPowerStructure) throws LoopDetectedException, DuplicatedEventException {
        RBDModel rbdModel = this.createRBDModel(applicationPowerStructure);
        ApplicationRBD appRBD = projectDesdac.getAppRBD();
        boolean duplicated = this.testDuplicatedComponents();
        if (duplicated) {
            // empty if block
        }
        appRBD.setRBDModel(rbdModel);
        GraphViewRBD.GraphViewInit(appRBD, null);
        GraphViewRBD.paint();
    }

    private void addComponentToBlock(ComponentGraphicalElement componentGraphicalElement, RBDModel rBDModel, BlockSeries blockSeries) throws LoopDetectedException {
        BlockExponential blockExponential = this.getBlockByComponent(componentGraphicalElement, rBDModel, blockSeries);
        if (blockExponential != null) {
            blockSeries.addBlock(blockExponential);
        }
    }

    private BlockExponential getBlockByComponent(ComponentGraphicalElement componentGraphicalElement, RBDModel rBDModel, BlockSeries blockSeries) throws LoopDetectedException {
        String name = componentGraphicalElement.getDataCenterComponent().getName();
        if (name.toLowerCase().startsWith("TargetPoint".toLowerCase()) || name.toLowerCase().startsWith("SourcePoint".toLowerCase())) {
            return null;
        }
        this.stringComponentNames.add(name);
        BlockExponential blockExponential = new BlockExponential(name, null, null);
        blockExponential.setFailureRate(1.0 / componentGraphicalElement.getDataCenterComponent().getMttf());
        blockExponential.setRepairRate(1.0 / componentGraphicalElement.getDataCenterComponent().getMttr());
        blockExponential.setIsMaintainabilityEdited(true);
        blockExponential.setIsReliabilityEdited(true);
        rBDModel.incrementIndexOfBlocks();
        rBDModel.incrementNumberOfBlocks();
        return blockExponential;
    }

    private Block createPath(GraphicalConnectionDataCenter graphicalConnectionDataCenter, ComponentGraphicalElement componentGraphicalElement, RBDModel rBDModel, BlockSeries blockSeries) throws LoopDetectedException {
        ArrayList<ComponentGraphicalElement> parentsComponents = this.getComponentParents(graphicalConnectionDataCenter, componentGraphicalElement);
        if (parentsComponents.size() == 0) {
            this.addComponentToBlock(componentGraphicalElement, rBDModel, blockSeries);
        } else if (parentsComponents.size() == 1) {
            this.addComponentToBlock(componentGraphicalElement, rBDModel, blockSeries);
            this.createPath(graphicalConnectionDataCenter, parentsComponents.get(0), rBDModel, blockSeries);
        } else if (parentsComponents.size() >= 1) {
            this.addComponentToBlock(componentGraphicalElement, rBDModel, blockSeries);
            BlockParallel blockParallel = new BlockParallel("");
            for (int i = 0; i < parentsComponents.size(); ++i) {
                BlockSeries newBlockSeries = new BlockSeries("");
                newBlockSeries = (BlockSeries)this.createPath(graphicalConnectionDataCenter, parentsComponents.get(i), rBDModel, newBlockSeries);
                if (newBlockSeries.getBlocks().size() > 1) {
                    blockParallel.addBlock(newBlockSeries);
                    continue;
                }
                if (newBlockSeries.getBlocks().size() != 1) continue;
                blockParallel.addBlock(newBlockSeries.getBlocks().get(0));
            }
            blockSeries.addBlock(blockParallel);
        }
        return blockSeries;
    }

    public void performAnalisysSPN(ProjectDesdac projectDesdac, ApplicationPowerStructure applicationPowerStructure, boolean isReliability) throws LoopDetectedException {
        GraphEdXPowerDataCenter graphEdXDataCenter = applicationPowerStructure.getGraphViewDataCenter().getApp();
        GraphicalConnectionDataCenter graphicalConnectionDataCenter = GraphicalConnectionDataCenter.createGraphicalConnectionDataCenter(graphEdXDataCenter);
        GraphEdX graphEdXSPN = projectDesdac.getAppSPN().getGraphView().getApp();
        ArrayList<ComponentGraphicalElement> componentGraphicalElements = graphicalConnectionDataCenter.getComponentGraphicalElements();
        int numBlocks = 0;
        for (int i = 0; i < componentGraphicalElements.size(); ++i) {
            ComponentGraphicalElement componentGraphicalElement = componentGraphicalElements.get(i);
            if (componentGraphicalElement.getDataCenterComponent().getName().toLowerCase().startsWith("SourcePoint".toLowerCase()) || componentGraphicalElement.getDataCenterComponent().getName().toLowerCase().startsWith("TargetPoint".toLowerCase())) continue;
            graphEdXSPN.createBlockExponential(new Point2D.Double(180 * (numBlocks + 1), 100.0), componentGraphicalElement.getDataCenterComponent().getName(), componentGraphicalElement.getDataCenterComponent().getMttf(), componentGraphicalElement.getDataCenterComponent().getMttr());
            ++numBlocks;
        }
        String failCondition = this.createFailCondition(applicationPowerStructure);
        String nameLogicBlock = "ALL";
        if (isReliability) {
            graphEdXSPN.createBlockLogicalReliability(new Point2D.Double(200 * (1 + numBlocks / 2), 350.0), nameLogicBlock, failCondition);
        } else {
            graphEdXSPN.createBlockLogicalAvailability(new Point2D.Double(200 * (1 + numBlocks / 2), 350.0), nameLogicBlock, failCondition);
        }
        graphEdXSPN.addRewardMeasure(nameLogicBlock);
    }

    private String createFailCondition(ApplicationPowerStructure applicationPowerStructure) throws LoopDetectedException {
        RBDModel rbdModel = this.createRBDModel(applicationPowerStructure);
        return this.createFailCondition(rbdModel.getModel());
    }

    private String createFailCondition(Block block) {
        String text = "";
        if (block instanceof BlockExponential) {
            text = "(#" + block.getName() + "_ON=0" + ")";
        } else if (block instanceof BlockChain) {
            BlockChain blockChain = (BlockChain)block;
            ArrayList<Block> blocks = blockChain.getBlocks();
            if (blocks.size() == 1) {
                text = this.createFailCondition(blocks.get(0));
            } else {
                text = "(";
                for (int i = 0; i < blocks.size(); ++i) {
                    Block newBlock = blocks.get(i);
                    if (i != blocks.size() - 1) {
                        if (blockChain instanceof BlockSeries) {
                            text = text + this.createFailCondition(newBlock) + "OR";
                            continue;
                        }
                        if (!(blockChain instanceof BlockParallel)) continue;
                        text = text + this.createFailCondition(newBlock) + "AND";
                        continue;
                    }
                    text = text + this.createFailCondition(newBlock);
                }
                text = text + ")";
            }
        }
        return text;
    }
}

