/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.powerstructure.gui.graphview;

import com.hp.desdac.powerstructure.entities.ApplicationPowerStructure;
import com.hp.desdac.powerstructure.entities.DataCenterArc;
import com.hp.desdac.powerstructure.entities.DataCenterComponent;
import com.hp.desdac.powerstructure.gui.graphview.ArrowGraphicalElement;
import com.hp.desdac.powerstructure.gui.graphview.ComponentGraphicalElement;
import com.hp.desdac.powerstructure.gui.graphview.GraphEdXPowerDataCenter;
import com.hp.desdac.powerstructure.gui.graphview.GraphViewPowerDataCenter;
import com.local.entities.ProjectDesdac;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.tree.TreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphModel;
import org.modcs.tools.spn.gui.graphview.GraphEdX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalConnectionDataCenter {
    private ArrayList<ComponentGraphicalElement> componentGraphicalElements;
    private ArrayList<ArrowGraphicalElement> arrowGraphicalElements;
    public static int counterPaint;

    public GraphicalConnectionDataCenter(ArrayList<ComponentGraphicalElement> componentGraphicalElements, ArrayList<ArrowGraphicalElement> arrowGraphicalElements) {
        this.componentGraphicalElements = componentGraphicalElements;
        this.arrowGraphicalElements = arrowGraphicalElements;
    }

    public GraphicalConnectionDataCenter() {
        this.componentGraphicalElements = new ArrayList();
        this.arrowGraphicalElements = new ArrayList();
    }

    public ArrayList<ArrowGraphicalElement> getArrowGraphicalElements() {
        return this.arrowGraphicalElements;
    }

    public void setArrowGraphicalElements(ArrayList<ArrowGraphicalElement> arrowGraphicalElements) {
        this.arrowGraphicalElements = arrowGraphicalElements;
    }

    public ArrayList<ComponentGraphicalElement> getComponentGraphicalElements() {
        return this.componentGraphicalElements;
    }

    public void setComponentGraphicalElements(ArrayList<ComponentGraphicalElement> componentGraphicalElements) {
        this.componentGraphicalElements = componentGraphicalElements;
    }

    private static ComponentGraphicalElement getComponentGraphicalElement(DefaultGraphCell defaultGraphCell, GraphEdX app) {
        Rectangle2D rectangle = app.getGraph().getCellBounds((Object)defaultGraphCell);
        Point2D.Double point = new Point2D.Double(rectangle.getX(), rectangle.getY());
        DataCenterComponent dataCenterComponent = (DataCenterComponent)defaultGraphCell.getUserObject();
        ComponentGraphicalElement cge = new ComponentGraphicalElement(dataCenterComponent, point);
        return cge;
    }

    public static GraphicalConnectionDataCenter createGraphicalConnectionDataCenter(GraphEdXPowerDataCenter app) {
        Object object;
        int i;
        GraphicalConnectionDataCenter graphicalConnectionDataCenter = new GraphicalConnectionDataCenter();
        GraphModel graphModel = app.getGraph().getModel();
        for (i = 0; i < graphModel.getRootCount(); ++i) {
            object = graphModel.getRootAt(i);
            if (object == null || !(object instanceof DefaultGraphCell)) continue;
            DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object;
            Rectangle2D rectangle = app.getGraph().getCellBounds((Object)defaultGraphCell);
            object = defaultGraphCell.getUserObject();
            if (!(object instanceof DataCenterComponent)) continue;
            DataCenterComponent dataCenterComponent = (DataCenterComponent)object;
            Point2D.Double point = new Point2D.Double(rectangle.getX(), rectangle.getY());
            ComponentGraphicalElement cge = new ComponentGraphicalElement(dataCenterComponent, point);
            graphicalConnectionDataCenter.getComponentGraphicalElements().add(cge);
        }
        for (i = 0; i < graphModel.getRootCount(); ++i) {
            object = graphModel.getRootAt(i);
            if (object == null || !(object instanceof DefaultEdge)) continue;
            DefaultEdge defaultEdge = (DefaultEdge)object;
            Object source = defaultEdge.getSource();
            Object target = defaultEdge.getTarget();
            if (!(source instanceof DefaultPort) || !(target instanceof DefaultPort)) continue;
            TreeNode sourceGraphCell = ((DefaultPort)source).getParent();
            TreeNode targetGraphCell = ((DefaultPort)target).getParent();
            DataCenterArc dataCenterArc = (DataCenterArc)defaultEdge.getUserObject();
            if (!(sourceGraphCell instanceof DefaultGraphCell) || !(targetGraphCell instanceof DefaultGraphCell)) continue;
            ComponentGraphicalElement cgeSource = GraphicalConnectionDataCenter.getComponentGraphicalElement((DefaultGraphCell)sourceGraphCell, app);
            ComponentGraphicalElement cgeTarget = GraphicalConnectionDataCenter.getComponentGraphicalElement((DefaultGraphCell)targetGraphCell, app);
            ArrowGraphicalElement arrowGE = new ArrowGraphicalElement(cgeSource, cgeTarget, dataCenterArc);
            graphicalConnectionDataCenter.getArrowGraphicalElements().add(arrowGE);
        }
        return graphicalConnectionDataCenter;
    }

    public static void createGraphicalConnection(ProjectDesdac projectDesdac) {
        GraphicalConnectionDataCenter graphicalConnectionDataCenter = GraphicalConnectionDataCenter.createGraphicalConnectionDataCenter(projectDesdac.getAppPowerStructure().getGraphViewDataCenter().getApp());
        projectDesdac.getAppPowerStructure().setGraphicalConnectionDataCenter(graphicalConnectionDataCenter);
    }

    public static void paintGraph(ApplicationPowerStructure applicationDataCenter) {
        GraphicalConnectionDataCenter.paintGraph(new Point2D.Double(0.0, 0.0), applicationDataCenter);
    }

    public static void paintGraph(Point2D local, ApplicationPowerStructure applicationDataCenter) {
        GraphicalConnectionDataCenter.paintGraph(local, applicationDataCenter.getGraphicalConnectionDataCenter(), applicationDataCenter.getGraphViewDataCenter());
    }

    public static void paintGraph(Point2D local, GraphicalConnectionDataCenter graphicalConnectionDataCenter, GraphViewPowerDataCenter graphViewDataCenter) {
        int i;
        ArrayList<ComponentGraphicalElement> graphicalElements = graphicalConnectionDataCenter.getComponentGraphicalElements();
        ArrayList<ArrowGraphicalElement> arrowGraphicalElements = graphicalConnectionDataCenter.getArrowGraphicalElements();
        GraphEdXPowerDataCenter graphEdXDataCenter = graphViewDataCenter.getApp();
        for (i = 0; i < graphicalElements.size(); ++i) {
            ComponentGraphicalElement componentGraphicalElement = graphicalElements.get(i);
            Point2D.Double newPoint = new Point2D.Double(local.getX() + componentGraphicalElement.getPoint().getX(), local.getY() + componentGraphicalElement.getPoint().getY());
            DataCenterComponent dataCenterComponent = componentGraphicalElement.getDataCenterComponent();
            if (counterPaint != 0) {
                String name = dataCenterComponent.getName();
                dataCenterComponent = new DataCenterComponent(dataCenterComponent.getType(), dataCenterComponent.getPath(), dataCenterComponent.getMttf(), dataCenterComponent.getMttr());
                dataCenterComponent.setName(name + "_I" + counterPaint);
            }
            graphEdXDataCenter.insert((Point2D)newPoint, dataCenterComponent);
        }
        for (i = 0; i < arrowGraphicalElements.size(); ++i) {
            ArrowGraphicalElement arrowGraphicalElement = arrowGraphicalElements.get(i);
            String nameSource = "";
            String nameTarget = "";
            if (counterPaint == 0) {
                nameSource = arrowGraphicalElement.getComponentSource().getDataCenterComponent().toString();
                nameTarget = arrowGraphicalElement.getComponentTarget().getDataCenterComponent().toString();
            } else {
                nameSource = arrowGraphicalElement.getComponentSource().getDataCenterComponent().getName() + "_I" + counterPaint;
                nameTarget = arrowGraphicalElement.getComponentTarget().getDataCenterComponent().getName() + "_I" + counterPaint;
            }
            DefaultGraphCell defaultGraphSource = GraphicalConnectionDataCenter.getVertexByName(nameSource, graphEdXDataCenter.getGraph());
            DefaultGraphCell defaultGraphTarget = GraphicalConnectionDataCenter.getVertexByName(nameTarget, graphEdXDataCenter.getGraph());
            graphEdXDataCenter.connectCells(defaultGraphSource, defaultGraphTarget, arrowGraphicalElement.getDataCenterArc());
        }
        ++counterPaint;
    }

    public static DefaultGraphCell getVertexByName(String name, JGraph jGraph) {
        DefaultGraphCell result = null;
        DefaultGraphModel model = (DefaultGraphModel)jGraph.getModel();
        for (int i = 0; i < model.getRootCount(); ++i) {
            DataCenterComponent dataCenterComponent;
            DefaultGraphCell defaultGraphCell;
            Object object = model.getRootAt(i);
            if (!(object instanceof DefaultGraphCell) || !((defaultGraphCell = (DefaultGraphCell)object).getUserObject() instanceof DataCenterComponent) || !(dataCenterComponent = (DataCenterComponent)defaultGraphCell.getUserObject()).getName().equals(name)) continue;
            result = defaultGraphCell;
            break;
        }
        return result;
    }
}

