/* Generated by Together */

#ifndef TOKEN_H
#define TOKEN_H

#include "DefaultGM.h"
#include "Simulation.h"
#include "DateTime.h"
#include "gmdb.h"


class Token;

typedef struct token_reference
{
   string tokentypename;
   SMARTPTR(Token) token;
   string attributename;
   int id;
} token_reference;

typedef vector<token_reference*, GCALLOC(token_reference*)> token_reference_list;

typedef struct token_info
{
   string tokentypename;
   SMARTPTR(Token) token;
   int id;
   string place_name;
} token_info;

typedef vector<token_info*, GCALLOC(token_info*)> token_info_list;

class Simulation;

#ifdef USE_BOEHM_GC
/*everything derived from this class will be 
  garbage collected*/
class Token : public gc_cleanup
#else
class Token
#endif
{
public:

   Token();
   Token(const Token &copy);
   virtual ~Token(void);

   const DateTime& getCreationTime() const { return creationTime; };

   void notifyTransitions(SMARTPTR(Token) token);
   void addTransition(Transition* transition);
   void removeTransition(Transition* transition);
   bool containsTransition(Transition* transition);

   virtual void setReferenceAttribute(const char *attributename, SMARTPTR(Token) reference) {};
   virtual Token& operator= (const Token& T);
   virtual bool operator==( const Token & T ) const;
   friend ostream& operator << (ostream& strm, const Token & X);

   virtual const string getName() const = 0;
   /**
   * Returns a string with the contents of this Token,
   * that means with all attributes.
   * This virtual method will be overwritten by all Token classes.
   * This method is mainly for the TokenGame and is called
   * from the content() method of the Place class.
   * ATTENTION: It isn't allowed to change the string format!!!
   */
   virtual const string content() const { return ""; }

   static SMARTPTR(Token) findToken(token_info_list &tokens, const char *tokentypename, int id);
    
   static long tokenCounter;
   static long concTokenCounter;
   static long maxConcTokenCounter;

private:
   TransitionList transitions;
   DateTime creationTime;
   int id;
};

#endif //TOKEN_H
