#ifndef RANDOMWRAPPER_H
#define RANDOMWRAPPER_H

#include "RngStream.h"

class RandomWrapper
{
private:
	static bool isinitialized;
	RngStream rngstream;
public:
	RandomWrapper()
	{
		assert(isinitialized);
	}
	static void SetPackageSeed (const unsigned long seed[6])
	{
		RngStream::SetPackageSeed(seed);
		isinitialized=true;
	}

	double randu01()
	{
		return rngstream.RandU01();
	}
	
	long randint(long i, long j)
	{
		return rngstream.RandInt ( i,  j);
	}
};

#endif
