/* Generated by Together */

#ifndef PLACE_H
#define PLACE_H

#include "DefaultGM.h"
#include "Simulation.h"
#include "MeasureObj.h"
#include "Token.h"
#include "Transition.h"

class Place : public DefaultGM
{
public:

   Place(int uniqueid, NetClass* net);
   Place(int uniqueid, const char* name, NetClass* net, const AttributeMap& attributes, bool FIFO=false, unsigned int capacity=0);
   Place(int uniqueid, const char* name, NetClass* net, bool FIFO=false, unsigned int capacity=0);
   ~Place(void);

   /**
    * Returns the unique id of this place.
    */
   inline int getID() const { return id; }

   /**
    * Returns only the first marking if place is FIFO,
    * otherwise it returns all current marking in this place.
    */
   const TokenList& getMarking();

   /**
    * Returns always the full current marking of this place.
    * This is needed for measures with token filter.
    */
   const TokenList& getFullMarking() const {return marking;}

   /**
    * Returns the real number of current markings in this place,
    * regardless of FIFO mode.
    */
   unsigned int getMarkingSize() const;

   /**
    * Adds a token to this place, notifies all global guards and adds
    * this token to the free list of all out transitions.
    */
   void addToken(SMARTPTR(Token) token);

   /**
    * Deletes a token from this place, notifies all global guards and deletes
    * this token from the free list of all out transitions.
    */
   void removeToken(SMARTPTR(Token) token);

   /**
    * Returns a list with all preliminary transitions.
    */
   inline TransitionList const& getInTransitions() const { return inTransitions; };

   /**
    * Returns a list with all downstream transitions.
    */
   inline TransitionList const& getOutTransitions() const { return outTransitions; };
   
   /**
    * Sets the watch attribute
    */
   inline void setWatch(bool wtch) { watch = wtch; };

   /**
    * Adds a preliminary transition to this place.
    */
   void addInTransition(Transition* trans);

   /**
    * Adds a downstream transition to this place.
    */
   void addOutTransition(Transition* trans);

   void addGlobalGuardTransition(Transition* trans);

   /**
    *	Returns TRUE if place is FIFO.
    */
   inline bool isFIFO() const { return FIFO; };


   void addMeasure(MeasureObj* measure);
   inline const MeasureVector& getMeasures() const { return measures; };

   bool canTake(unsigned int count) const;

   /**
    * Returns a string that contains a description of all tokens
    * of this place together with their color (attributes).
    */
   const string content() const;	

   friend ostream& operator << (ostream& strm, const Place & X);

   /**
    *	Writes all preliminary and downstream transition to the standard output.
    */
   void printTrans(void);

   void displContent(void);

private:
   /**
    * a list with all preliminary transitions.
    */
   TransitionList inTransitions;

   /**
    * a list with all downstream transitions.
    */
   TransitionList outTransitions;

   TransitionList globalGuardTransitions;

   /**
    * a list that contains all tokens of this place
    */
   TokenList marking;

   /**
    * a list that contains only the first token of this place (for FIFO) 
    */
   TokenList lastMarking;

   MeasureVector measures;

   bool FIFO;
   bool watch;
   unsigned int capacity;
   int id;

   void notifyGlobalGuardTransitions(void);
};

#endif //PLACE_H
