#ifndef NETCLASS_H
#define NETCLASS_H

#include "gmnet.h"
#include "Place.h"
#include "Transition.h"
#include "MeasureObj.h"

class NetClass
{
public:
   NetClass();
   virtual ~NetClass();

   // virtual functions which are implemented in buildnet.cpp
   virtual void buildNet() = 0;
   virtual void createTokens() = 0;

   inline void setSimulation(Simulation* simu) { sim = simu; };
   inline Simulation* getSimulation() const { return sim; };
   inline const PlaceMap& getPlaces() const { return placeByName; };
   inline const TransitionMap& getTransitions() const { return transitionByName; };

   void addPlace(Place*);
   void addTransition(Transition*);
   void addMeasure(MeasureObj*);

   void linkPlaceToTransition(const char*, const char*);
   void linkTransitionToPlace(const char*, const char*);
   void linkIntoTransition(Place* src, Transition* dest);
   void linkOutOfTransition(Transition* src, Place* dest);

   Place* getPlace(const char*);
   Place* getPlace(const string&);
   Place* getPlace(int id);
   Place* getPlace(PlaceIdentMap* places, const char* name);
   Transition& getTransition(const char*);
   Transition* getTransition(int id);
   const MeasureList &getMeasureList () const {return measureList;}

   string writeMaps();

   void restoreNet();
   void storeMeasureList();
   void loadMeasureList();
   inline void clearMaps() {storeMeasureList();
   							placeByName.clear(); 
   							transitionByName.clear(); 
   							measureList.clear();}
   
   inline MeasureList& getMeasureList() {return measureList;}
   
private: // Private attributes
   PlaceMap placeByName;
   TransitionMap transitionByName;
   MeasureList measureList, s_measureList;
   Simulation* sim;
};

#endif
