/*NEUE_VERSION (BM)*/
/*************************************************************************

  filename:	stat_utils.h

  purpose:	Constants and types will be defined for stat_utils.c

  author:	Christian Kelling
		Technical University of Berlin
		Computer Science Department
		Institute for Technical Computer Science

  date:		May 1993

  Datei im Ramen des PDV-Projekts im WS 95/96 gendert.

  nderung:       STAT_BLOCK_DEF und RECEIVE_BLOCK_DEF definiert.

  	          STAT_BLOCK_DEF defineirt die kleinste Blockgre im
		  Maspeicher. Es ist sinnvoll den Wert 1 beizu behalten, da
		  dies die grte Performance-Verbesserung mit sich bringt.

		  RECEIVE_BLOCK_DEF definiert die maximale Empfangspuffergre.
		  Es ist zu beachten, da die RECEIVE-Blockgre nicht kleiner
		  als die SEND-Blockgre sein darf.
		  Dieses MACRO ist nur der Verstndlichkeit wegen eingefhrt
		  worden


  Autoren:	Mathias Neumann und Benjamin Hohnhuser 

  Datum:   	April 1996

*************************************************************************/

#define  SUCCEED    0
#define  FAIL       1

#define EQU_MAX		100     /* max. number of successive equal samples */
				/* before assuming: no variance */

#define MIN_FIRINGS	50 	/* each transition should have been fired 
				   MIN_FIRINGS times to ensure 
				   valid statistics*/

#define LOCAL_BATCH_SIZE_DEF	20	/*-20- number of samples to batch at
					 *slave before record in sequence */

#define SEND_BLOCK_DEF	10	/*maximale Sendeblockgre (BM)*/

#define STAT_BLOCK_DEF	1	/* Blockgre im Maspeicher (BM)
				 * Es ist sinnvoll den Wert 1 beizu-
				 * behalten, da dies die grte
				 * Performance-Verbesserung
				 * mit sich bringt*/

#define RECEIVE_BLOCK_DEF SEND_BLOCK_DEF   /* max. Empfangspuffergre (BM)
					    * Es ist zu beachten, da die 
					    * RECEIVE-Blockgre gleich der 
					    * SEND-Blockgre sein mu.
					    * Dieses MACRO ist nur der 
					    * Verstndlichkeit wegen eingefhrt
					    * worden */

#define MAX_SAMPLES_DEF 0x7FFFFFFF  /* 500000: a useful value,
				  0x7FFFFFFF: max possible value */

/* node of linked list to collect sampled data */
typedef struct t_SampleSequence
	{
	double Value;
	struct t_SampleSequence *Next;
	} SampSeq;


double means ();
 double normal_distr();
 double student_distr();
double periodogram ();
double SpectralVarAnalysis();

#define MAX_THRESHOLDS 30

/*#define DEBUG_RST */      /* If this activated you get some debugging Information */
                       /* Simulation with RESTART, see 'receive_samples()' below */



