/**
 * Stellt einfache Systemfunktionen zur Verfuegung.
 */
function System() {
  // noop.
}


/**
 * Prints an "OK"
 */
System.ok = function()
{
    println("OK");
}


/**
 * Prints a "FAILED!".
 */
System.failed = function()
{
    println("FAILED!");
}


/**
 * Executes a given command.
 *
 * @param cmdLine A line of command(s) to execute.
 * @return An object representing the result, has properties .stdout, .stderr, exitValue 
 */
System.command = function(cmdLine)
{
    try {
        var result = {};

        var p = Packages.java.lang.Runtime.getRuntime().exec(cmdLine);

        result.stdout = "";
        result.stderr = "";
        var stdout = p.getInputStream();
        var stderr = p.getErrorStream();
        var avail;

        do {
            avail = stdout.available();
            for (var idx = 0; idx < avail; idx++)
                result.stdout += Packages.java.lang.Character(stdout.read());
            avail = stderr.available();
            for (var idx = 0; idx < avail; idx++)
                result.stderr += Packages.java.lang.Character(stderr.read());
            try {
                result.exitValue = p.exitValue();
                break;
            } catch (ex) {
                Packages.java.lang.Thread.sleep(100);
            }
        } while(true);

        return result;
    } catch (ex) {
        println(ex);
	session.throwException("System.command(\"" + cmdLine + "\") failed:\n" + ex);
    }
}


/**
 * Copies a file from source to dest.
 *
 * @param source The source file (name + path)
 * @param dest The destination file (name + path)
 */
System.copyFile = function(source, dest)
{
    var inStream = new Packages.java.io.FileInputStream(source);

    try {
        var outStream = new Packages.java.io.FileOutputStream(dest);
        try {
            Packages.de.pinuts.util.StreamFun.CopyStreams(inStream, outStream);
        }
        finally {
            outStream.close();
        }
    }
    finally {
        inStream.close();
    }
}


/**
 * Starts the simulation of the given net with
 * the given parameters.
 *
 * @param net The net to simulate
 * @param name of the temporary file to create
 * @param startTime Time of simualtion start, using TimeNET standard time format ("time@date")
 * @param endTime Time of simulation end, using TimeNET standard time format ("time@date")
 */
System.runNet2 = function(net, name, startTime, endTime)
{
  if (startTime == null) {
    startTime = "12:00:00@01/01/2003";
  }
   
  if (endTime == null) {
    endTime = "12:00:00@02/02/2003";
  }

  net.javaObject.prepare();
  net.check();
  net.toFile(name + ".xml");
  net = Net.load(name+".xml");
  
  var codeGen = new Packages.gpal.codegen.CodeGen("./" + name + ".dir", net.javaObject, name, false, false, gpsc_out, gpsc_out);
  println(" ... starting code gen");
  codeGen.run();

  var TNETHOME = java.lang.System.getProperty("TNETHOME");

  System.copyFile(TNETHOME+"/SCPN/scripts/Makefile", name + ".dir/Makefile");
  var cmdline = "make -C " + name + ".dir";
  println(" ... starting make: " + cmdline);
  var make = System.command(cmdline);
  
  if (make.exitValue == 0) {
    cmdline = name + ".dir/" + name + ".sim --simulation --start " + startTime + " --stop " 
      + endTime + " -l -logdir " + name + ".dir/" + name + ".log";
    //println("... starting simulation: " + cmdline);
    var sim = System.command(cmdline);
    //println(">> " + sim.stdout);
    if (sim.exitValue == 0) {
      var result = {};
      
      var m = sim.stdout.match("Global fire count: ([0-9]*)");
      
      if (m != null) {
	result.globalFireCount = m[1];                
      }
      
      return result;
    } else {
      System.failed();
    }
  } else {
    System.failed();
    println("--->\n" + make.stderr + "<---");
  }
  
  return null;
}

/**
 * Starts a simulation using the RemoteSystem. It is planed to use the ResultMonitor as well, but this is not implemented yet.
 *
 * @param name The full name of the net file
 * @param startTime The simulation's start time
 * @param endTime The simulation's end time
 * @param serverIP The IP of the machine where the RemoteServer is running. Can be null or "localhost" as well as a usual IP address
 * @param serverPort The listening port of the RemoteServer
 * @param resultIP The IP of the machine where the ResultMonitor is running. Can be null or "localhost" as well as a usual IP address
 * @param resultPort The listening port of the ResultMonitor
 * @param logging Activates the logging function of the simulation if set to true
 */
System.runNet = function(name, startTime, endTime, serverIP, serverPort, resultIP, resultPort, logging) {
    parameters = new Packages.client.SimulationParameters(startTime, endTime);
    parameters.setServerIP(serverIP);
    parameters.setServerPort(serverPort);
    parameters.setResultIP(resultIP);
    parameters.setResultPort(resultPort);
    parameters.setLogging(logging);
    
    gpsc_instance.startSimulation(name, parameters);
}

/**
 * Starts a simulation using the RemoteSystem. It is planed to use the ResultMonitor as well, but this is not implemented yet.
 *
 * @param name The full name of the net file
 * @param startTime The simulation's start time
 * @param endTime The simulation's end time
 * @param serverIP The IP of the machine where the RemoteServer is running. Can be null or "localhost" as well as a usual IP address
 * @param serverPort The listening port of the RemoteServer
 * @param resultIP The IP of the machine where the ResultMonitor is running. Can be null or "localhost" as well as a usual IP address
 * @param resultPort The listening port of the ResultMonitor
 * @param logging Activates the logging function of the simulation if set to true
 * @param seed Random seed
 */
System.runNetSeeded = function(name, startTime, endTime, serverIP, serverPort, resultIP, resultPort, logging, seed) {
    parameters = new Packages.client.SimulationParameters(startTime, endTime);
    parameters.setServerIP(serverIP);
    parameters.setServerPort(serverPort);
    parameters.setResultIP(resultIP);
    parameters.setResultPort(resultPort);
    parameters.setLogging(logging);
    parameters.setSeed(seed);
    
    gpsc_instance.startSimulation(name, parameters);
}

/** 
 * Gets the value of a result measure from a result file generated after a simulation run.
 *
 * @param resultName The name of the result measure to get the value for
 * @param netName The name of the net file (without extension) the measure belongs to
 */
System.getValue = function(resultName, netName) {
	return gpsc_instance.getValue(resultName, netName);
}
