// -*- java -*-
//
// $Id: SubstTransitionTest.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  SubstTransitionTest
// *************************************

function createTwoReplications(substTrans, p1, p2) {
  // create replications:
  
  var rep1 = Replication.create(substTrans);
  var rep2 = Replication.create(substTrans);

  // build rep1 subnet:
  // first step: clone connected nodes into replication:
  var sp1_1 = p1;
  rep1.addSlavePlace(sp1_1);

  var sp1_2 = p2;
  rep1.addSlavePlace(sp1_2);

  var it = ImmediateTransition.add(rep1, "ImmT1", "1", "1");
  var iArc1 = InputArc.add(rep1, sp1_1, it, "a");
  var oArc1 = OutputArc.add(rep1, it, sp1_2, "a");

  assert(rep1 != null && sp1_1 != null && sp1_2 != null && it != null && iArc1 != null && oArc1 != null, 
	 "first replication created and filled: "); 

  // build rep2 subnet:
  // clone connected places into replication:
  var sp2_1 = p1;
  rep2.addSlavePlace(sp2_1);

  var sp2_2 = p2;
  rep2.addSlavePlace(sp2_2);
  
  var tt = TimedTransition.add(rep2, "TimT1", "1");
  var iArc2 = InputArc.add(rep2, sp2_1, tt, "a");
  var oArc2 = OutputArc.add(rep2, tt, sp2_2, "a");
  
  assert(rep2 != null && sp2_1 != null && sp2_2 != null && tt != null && iArc2 != null && oArc2 != null,
	 "second replication created and filled: ");
}

var rootNet = Net.create();
var substTr = SubstitutionTransition.add(rootNet, "SubstTest");

var p1 = Place.add(rootNet, "test1", "int", "1", "FIFO", "true", "");
var p2 = Place.add(rootNet, "test2", "int", "1", "FIFO", "true", "");

var inArc = InputArc.add(rootNet, p1, substTr, "a");
var outArc = OutputArc.add(rootNet, substTr, p2, "a");

assert(rootNet != null && substTr != null && p1 != null && p2 != null 
       && inArc != null && outArc != null,
       "Base net, places, arcs and substitution transition created: ");

createTwoReplications(substTr, p1, p2);

rootNet.check();

assert(rootNet.toFile("substTest.xml"), "Net dumped to substTest.xml: ");

