// -*- java -*-
//
// $Id: SmokeTest.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  SmokeTest
// *************************************

function placeTest() {
  var place1 = Place.add(testNet, "place1", "int", "1", "FIFO", "true", "");
  assert(place1 != null, "Create place1: ");
  assert(place1.getName().equals("place1"), "place1.getName() eq 'place1': ");
 
  var place2 = Place.add(testNet, "place2", "int", "1", "FIFO", "true", "");
  assert(! place1.equals(place2), "place1 neq place2: ");
  assert(place1.equals(place1), "place1 eq place1: ");
}

function tokentypeTest() {
    var rct1 = RecordTokentype.add(testNet, "RecordTokentype No. 1");
    assert(rct1 != null, "Create record tokentype 1: ");
    
    var attr1 = rct1.addAttribute("a", "int");
    assert(attr1 != null, "Create and add attribute: ");

    //rct1.listAttributes();
}

function netTest() {
    var simpleNet = Net.load("SCPN/SimpleTest.xml");
    assert(simpleNet != null, "Load 'SimpleText.xml' net from file: ");

    var place1 = Place.withName(simpleNet, "XPool");
    assert(place1 != null, "Get place 'XPool': ");
    assert(place1.getID().equals("0.10"), "Place XPool has ID '0.10': "); 
    
}

var testNet = Net.create();
assert(testNet != null, "Create test net: ");

placeTest();
tokentypeTest();
netTest();

