// -*- java -*-
//
// $Id: NetbuildingTest.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  NetbuildingTest
// *************************************

function addObjects(rootNet) {
  // add some places
  p1 = Place.add(rootNet, "test1", "int", "1", "FIFO", "true", "");
  p2 = Place.add(rootNet,"test2", "int", "1", "FIFO", "true", "");
  p3 = Place.add(rootNet, "test3", "int", "1", "FIFO", "true", "");
  p4 = Place.add(rootNet, "test4", "int", "1", "FIFO", "true", "");
  p5 = Place.add(rootNet, "test5", "int", "1", "FIFO", "true", "");
  p6 = Place.add(rootNet, "test6", "int", "1", "FIFO", "true", "");

  t1 = ImmediateTransition.add(rootNet, "T1", "1", "1");
  t2 = ImmediateTransition.add(rootNet, "T2", "1", "1");
  t3 = ImmediateTransition.add(rootNet, "T3", "1", "1");
  t4 = ImmediateTransition.add(rootNet, "T4", "1", "1");

  inArc1 = InputArc.add(rootNet, p1, t1, "a");
  inArc2 = InputArc.add(rootNet, p3, t1, "b");
  inArc3 = InputArc.add(rootNet, p5, t1, "c");
  outArc1 = OutputArc.add(rootNet, t1, p2, "a");
  outArc2 = OutputArc.add(rootNet, t1, p4, "b");
  outArc3 = OutputArc.add(rootNet, t1, p6, "c");
  
  inArc4 = InputArc.add(rootNet, p4, t2, "d");
  inArc5 = InputArc.add(rootNet, p6, t3, "c");
  inArc6 = InputArc.add(rootNet, p2, t4, "e");
  outArc4 = OutputArc.add(rootNet, t2, p3, "d");
  outArc5 = OutputArc.add(rootNet, t3, p5, "c");
  outArc5 = OutputArc.add(rootNet, t4, p1, "e");

  measure = Measure.add(rootNet, "TestMeasure","#test1");
  definition = Definition.add(rootNet, "TestDefinition", "#test2");
}

function showPlaces(testNet) {
  var places = testNet.getPlaces();
  for (idx=0; idx < places.length; idx++) {
      assert(places[idx].javaObject.getName().equals("test"+(idx+1)), "Name of Place["+idx+"]:");
      //println("Place["+idx+"]: "+places[idx].javaObject.getName());
  }
}

// main work.
rootNet = Net.create();
addObjects(rootNet);
rootNet.check();
showPlaces(rootNet);
rootNet.toFile("heikotest.xml");

