// -*- java -*-

/**
 * Prints a String.
 *
 * @param str The String to print
 */
function print(str)
{
    if (str != null)
        gpsc_out.print(str);
    else
        gpsc_out.print("null");
}


/**
 * Prints a String and then terminates the current line.
 *
 * @param str The String to print
 */
function println(str)
{
    if (str != null)
        gpsc_out.print(str + "\n");
    else
        gpsc_out.print("null\n");
    gpsc_out.flush();
}


/**
 * Reads a line of input.<br>
 *
 * This ist either done by reading a console input or the input from a GUI dialog, depending if GPSC is used in addition to a GUI or not.
 *
 * @param message A message that will be printed right before the input is read
 */
function readln(message)
{
	return gpsc_instance.getLine(message);
}


/**
 * Reads in a boolean input.<br>
 * 
 * The Strings representing the two possible options as well as a message for the user can be specified. For example the call of <br><br>
 * <code>choice("Start Simulation?", "yes", "no");</code><br><br>
 * would result in prompting<br><br>
 * <tt>Start Simulation?([y]es/[n]o)</tt><br><br>
 * on the console. If 'y' or 'Y' would be entered <code>choice</code> would return <code>true</code> and <code>false</code> if 'n' or 'N' would be entered.<br>
 * If using GPSC with a GUI, a call of <code>choice</code> opens a message box containing the passed message and two buttons with the labels "yes" and "no".
 *
 * @param message The message to be displayed when asking the user for his choice
 * @param trueString The String representing the <code>true</code> option
 * @param falseString The String representing the <code>false</code> option
 * @return <code>true</code> if the user chooses the option represented by <code>trueString</code>, <code>false</code> otherwise
 */
function choice(message, trueString, falseString) {
	return gpsc_instance.choice(message, trueString, falseString);
}



function source(filename)
{
    var reader = new java.io.FileReader(filename);

    gpsc_context.evaluateReader(gpsc_scope, reader, filename, 1, null);

    reader.close();
}

/**
 * 'Sources' a resource with the given name.
 */
function sourceAPI(filename)
{
    gpsc_instance.sourceAPIResource(filename);
}


// source SCPN api files:
sourceAPI("jsapi/SCPN/Net.js");
sourceAPI("jsapi/SCPN/Place.js");
sourceAPI("jsapi/SCPN/ImmediateTransition.js");
sourceAPI("jsapi/SCPN/TimedTransition.js");
sourceAPI("jsapi/SCPN/InputArc.js");
sourceAPI("jsapi/SCPN/OutputArc.js");
sourceAPI("jsapi/SCPN/Definition.js");
sourceAPI("jsapi/SCPN/Measure.js");
sourceAPI("jsapi/SCPN/Module.js");
sourceAPI("jsapi/SCPN/ModuleInstance.js");
sourceAPI("jsapi/SCPN/ModulePin.js");
sourceAPI("jsapi/SCPN/SubstitutionTransition.js");
sourceAPI("jsapi/SCPN/Replication.js");
sourceAPI("jsapi/SCPN/RecordTokentype.js");
sourceAPI("jsapi/SCPN/Attribute.js");

// source utilities:
sourceAPI("jsapi/util/System.js");
sourceAPI("jsapi/util/PlaceFactory.js");

// source Tests:
//sourceAPI("jsapi/Test.js");


