
/**
 * Creates a Test object.
 * This test is used to demonstrate the instanceof in JavaScript, used
 * in the equals() method.
 * 
 * @param a An Object to use in equals
 * @param b Another Object to use in equals
 * @param c Another Object to use in equals
 */
function Test(a,b,c) {
  this.a = a;
  this.b = b;
  this.c = c;
}

/**
 * Returns true, if the provided object is another Test object and has
 * the same values for a,b and c.
 *
 * @param anotherTest The other object for this operation.
 */
Test.prototype.equals = function(anotherTest) {
  if (anotherTest == null) {
    println("test is null.");
    session.throwException();
  } else if (!(anotherTest instanceof Test)) {
    println("test ! instanceof Test");
    session.throwException();
  } else {
    if (this.a == anotherTest.a &&
        this.b == anotherTest.b &&
        this.c == anotherTest.c)
      return true;
    else
      return false;
  }
} 


/**
 * Executes the other test routines.
 */
sourceAPI("jsapi/test/TestBase.js");

printlnComment("Data Test START", "--- ", "------");
sourceAPI("jsapi/test/DataTest.js");
printlnComment("Data Test END", "--- ", "------");
println("");
printlnComment("Netbuilding Test START", "--- ", "------");
sourceAPI("jsapi/test/NetbuildingTest.js");
printlnComment("Netbuilding Test End", "--- ", "------");
println("");
printlnComment("Substitution Transition Test START", "--- ", "------");
sourceAPI("jsapi/test/SubstTransitionTest.js");
printlnComment("Substitution Transition Test END", "--- ", "------");
println("");
printlnComment("Smoke Test START", "--- ", "------");
sourceAPI("jsapi/test/SmokeTest.js");
printlnComment("Smoke Test END", "--- ", "------");
println("");
println("Tests finished!");


// last line defines result:
"OK";
