// -*- java -*-
//
// $Id: TimedTransition.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  Timed Transition
// *************************************

/**
 * Creates a new TimedTransition object.
 *
 * @param javaObject The java object to encapsulate.
 */
function TimedTransition(javaObject) {
    if (javaObject == null) {
	session.throwException("TimedTransition constructor: provided javaObject == null!");
    }
    this.javaObject = javaObject;
}


/**
 * Adds a new TimedTransition to the specified net with the provided properties.
 *
 * @param net The net to add the TimedTransition to
 * @param name The name of the TimedTransition
 * @param timeFunction The time function to set.
 * @return The new TimedTransition object.
 */
TimedTransition.add = function(net, name, timeFunction) {
  if (net == null)
    session.throwException("No net for TimedTransition.add()!");
  if (name == null)
    session.throwException("No name for Timed Transition!");
  if (timeFunction == null)
    session.throwException("No time function for Timed Transition!");
  
  return new TimedTransition(session.addTimedTransition(net.javaObject, name, timeFunction));   
}


/**
 * Searches the TimedTransition with the given name.
 *
 * @param net The net to search in.
 * @param name The name of the TimedTransition to find.
 * @return The TimedTransition, if found.
 */
TimedTransition.withName = function(net, name) {
  if (net == null)
    session.throwException("No net for TimedTransition.withName()!");
  if (name == null) {
    session.throwException("TimedTransition.withName: provided name == null!");
  }

  var trans = session.getTimedTransitionWithName(net.javaObject, name);
  if (trans == null) {
    session.throwException("Could not find TimedTransition " + name + "!");
  }
  return new TimedTransition(trans);
}


/**
 * Returns the name of this timed transition.
 * 
 * @return This transition's name.
 */
TimedTransition.prototype.getName = function() {
    return this.javaObject.getName();
}


/**
 * Returns the ID of this timed transition.
 * 
 * @return This transition's ID.
 */
TimedTransition.prototype.getID = function() {
    return this.javaObject.getId();
}


/**
 * Sets the local guard of this timed transition.
 *
 * @param guardStr The new local guard expression.
 */
TimedTransition.prototype.setLocalGuard = function(guardStr) {
    this.javaObject.setLocalGuard(guardStr);
}


/**
 * Returns the actual local guard expression.
 *
 * @return The guard expression of this timed transition.
 */
TimedTransition.prototype.getLocalGuard = function() {
    return this.javaObject.getLocalGuard().toString();
}


/**
 * Sets the global guard of this timed transition.
 *
 * @param guardStr The new global guard expression.
 */
TimedTransition.prototype.setGlobalGuard = function(guardStr) {
    this.javaObject.setGlobalGuard(guardStr);
}


/**
 * Returns the actual global guard expression.
 *
 * @return The guard expression of this timed transition.
 */
TimedTransition.prototype.getGlobalGuard = function() {
    return this.javaObject.getGlobalGuard().toString();
}


/**
 * Returns the time function.
 *
 * @return The time function.
 */
TimedTransition.prototype.getTimeFunction = function() {
    return this.javaObject.getTimeFunction().getExpressionStr();
}


/**
 * Sets the time function.
 *
 * @param expression The new time function to set.
 */
TimedTransition.prototype.setTimeFunction = function(expression) {
    this.javaObject.setTimeFunction(expression);
}


/**
 * Returns the value of this tranision's watch attribute.
 */
TimedTransition.prototype.getWatch = function() {
	return this.javaObject.getWatch();
}


/**
 * Sets the value of this transition's watch attribute.
 *
 * @param w The new value of the watch attribute.
 */
TimedTransition.prototype.setWatch = function(w) {
	this.javaObject.setWatch(w);
}


/**
 * Returns the value of this transition's SpecType attribute.
 */
TimedTransition.prototype.getSpecType = function() {
	return this.javaObject.getSpecType();
}


/**
 * Sets the value of this transition's SpecType attribute.
 *
 * @param spec The new value of the SpecType attribute
 */
TimedTransition.prototype.setSpecType = function(spec) {
	this.javaObject.setSpecType(spec);
}


/**
 * Sets the display expression.
 *
 * @param expression The new display expression to set.
 */
TimedTransition.prototype.setDisplayExpression = function(expression) {
    this.javaObject.setDisplayExpression(expression);
}


/**
 * Returns the value of the display expression.
 */
TimedTransition.prototype.getDisplayExpression = function() {
	return (this.javaObject.getDisplayExpression()).toString();
}


/**
 * Sets the server type.
 *
 * @param expression The new server type to set.
 */
TimedTransition.prototype.setServerType = function(expression) {
    this.javaObject.setServerType(expression);
}


/**
 * Returns the server type.
 */
TimedTransition.prototype.getServerType = function() {
	return this.javaObject.getServerType();
}


/**
 * Sets the value of the takeFirst attribute.
 *
 * @param takeFirst The new value of the takeFirst attribute.
 */
TimedTransition.prototype.setTakeFirst = function(takeFirst) {
	this.javaObject.setTakeFirst(takeFirst);
}


/**
 * Returns the value of the takeFirst attribute.
 */
TimedTransition.prototype.getTakeFirst = function() {
	return this.javaObject.getTakeFirst();
}


/** 
 * Sets this transition's manual code.
 */
TimedTransition.prototype.setManualCode = function(code) {
	this.javaObject.setManualCode(code);
}


/**
 * Returns this transition's manual code.
 */
TimedTransition.prototype.getManualCode = function() {
	return this.javaObject.getManualCode();
}


/**
 * Returns this transition's logfile name.
 */
TimedTransition.prototype.getLogfileName = function() {
	return this.javaObject.getLogfileName();
}


/**
 * Returns this tranistion's logfile description.
 */
TimedTransition.prototype.getLogfileDescription = function() {
	return this.javaObject.getLogfileDescription();
}


/**
 * Returns this transition's logfile expression.
 */
TimedTransition.prototype.getLogfileExpression = function() {
	return this.javaObject.getLogfileExpressionStr();
}


/**
 * Sets the parameters for this transition's logfile.
 */
TimedTransition.prototype.setLogfileParameters = function(filename, expression, description) {
	this.javaObject.setLogfileParameters(filename, expression, description);
}