// -*- java -*-
//
// $Id: Replication.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  Replication
// *************************************

/**
 * Creates a new Replicaton object.
 *
 * @param javaObject The java object to encapsulate.
 */
function Replication(javaObject) {
    if (javaObject == null) {
	session.throwException("Replication constructor: provided javaObject == null!");
    }
    this.javaObject = javaObject;
}


/**
 * Creates a new Replication for the speified substitution transition.
 *
 * @param substTrans The substitution transition to create a new replication for.
 * @return The newly created replication.
 */
Replication.create = function(substTrans) {
    var javaRep = session.createReplication(substTrans.javaObject);
    if (javaRep == null) {
	session.throwException("Could not create Replication, java object is null!");
    } else {
	return new Replication(javaRep);
    }
}


/**
 * Adds new SlavePlaces to the Replication.
 *
 * @param place The place to create a slave representation inside the Replication.
 */
Replication.prototype.addSlavePlace = function(place) {
    if (place == null || place.javaObject == null) {
	session.throwException("Replication.addSlavePlace: No valid place given.");
    } else {
	this.javaObject.addPlace(place.javaObject);
    }
}


