// -*- java -*-
//
// $Id: RecordTokentype.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  RecordTokentype
// *************************************

/**
 * Creates a new RecordTokentype object.
 *
 * @param javaObject The java object to encapsulate.
 */
function RecordTokentype(javaObject) {
  if (javaObject == null) {
    session.throwException("RecordTokentype constructor: provided javaObject == null!");
  }
  this.javaObject = javaObject;
}


/**
 * Adds a new empty RekordTokentype to the specified net.
 *
 * @param net The net to create the RecordTokentype in.
 * @param name The name of the new RecordTokentype.
 * @return The new RecordTokentype object.
 */
RecordTokentype.add = function(net, name) {
  if (net == null) {
    session.throwException("RecordTokentype.create: provided net is null.");
  }

  if (name == null) {
    session.throwException("RecordTokentype.create: provided name is null.");
  }
  
  return new RecordTokentype(session.addRecordTokentype(net.javaObject, name));
}


/**
 * Adds a new Attribute to this RecordTokentype object.
 *
 * @param name The name of the attribute.
 * @param type The type of the attribute.
 * @return The added Attribute.
 */
RecordTokentype.prototype.addAttribute = function(name, type) {
  var attr = session.getAttribute(this.javaObject, name, type);

  this.javaObject.addAttribute(attr);

  return new Attribute(attr);
}


/**
 * Lists all available attributes.
 */
RecordTokentype.prototype.listAttributes = function() {
  var attrs = this.javaObject.getAttributes();
  
  if (attrs != null && attrs.length > 0) {
    for (idx=0; idx < attrs.length; idx++) {
      println("["+idx+"] "+attrs[idx].toString());
    }
  } else {
    println("RecordTokentype has no attributes.");
  }
}

