// -*- java -*-
//
// $Id: OutputArc.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  OutputArc
// *************************************

/**
 * Creates a new OutputArc object.
 * 
 * @param javaObject The java object to encapsulate
 */
function OutputArc(javaObject) {
    if (javaObject == null) {
	session.throwException("OutputArc constructor: provided javaObject == null!");
    }
    this.javaObject = javaObject;
}


/**
 * Adds a new OutputArc to the given net and connects place and transition.
 *
 * @param net The net to add the input arc to.
 * @param transition The Transition where this arc should start.
 * @param place The place to end the output arc.
 * @param inscription The inscription of this arc.
 * @return The new OutputArc.
 */
OutputArc.add = function(net, transition, place, inscription) {	
    if (net == null) {
	session.throwException("InputArc.add: provided net == null!");
    }
    
    if (! (place instanceof Place)) {
	session.throwException("OutputArc.add: given place is not of type Place.");
    }

    if (! (transition instanceof ImmediateTransition) && 
	! (transition instanceof TimedTransition) && 
	! (transition instanceof SubstitutionTransition) && 
	! (transition instanceof ModulePin))
    { 
	session.throwException("OutputArc.add: given transition is not of type "
			       +"ImmediateTransition, TimedTransition, SubstitutionTransition"
			       +" or ModulePin.");
    }

    var javaArc = session.addOutputArc(net.javaObject, transition.javaObject, place.javaObject, inscription);
    return new OutputArc(javaArc);
}

/** 
 * Tries to find an arc specified by its from- and to-node.
 *
 * @param net The net to search in.
 * @param transition The transition the arc starts from.
 * @param place The place the arc ends in.
 * @param The arc, if found.
 */
OutputArc.getFromTo = function(net, transition, place) {
    arcs = net.getArcs();
    var arc = null;
    
    if (! (place instanceof Place)) {
	session.throwException("OutputArc.getFromTo: given place is not of type Place.");
    }

    if (! (transition instanceof ImmediateTransition) && 
	! (transition instanceof TimedTransition) && 
	! (transition instanceof SubstitutionTransition))
    { 
	session.throwException("OutputArc.getFromTo: given transition is not of type "
			       +"ImmediateTransition, TimedTransition, SubstitutionTransition"
			       +" or ModulePin.");
    }
    
    for (k = 0; k < arcs.length; k++) {
        if(arcs[k] instanceof OutputArc) {
            fplace = arcs[k].getPlace();
            ftransition = arcs[k].getTransition();
            if ((fplace.getID()).equals(place.getID()) && (ftransition.getID()).equals(transition.getID())) {
                arc = arcs[k];
                return arc;
            }
        }
    }
    
    if (arc == null) {
        session.throwException("OutputArc.getFromTo: given arc could not be found.");
    }
}

/**
 * Sets the inscription of this arc.
 *
 * @param inscr The inscription to set.
 */
OutputArc.prototype.setInscription = function(inscr) {
    this.javaObject.setInscriptionStr(inscr);
}

/**
 * Returns the inscription of this arc.
 */
OutputArc.prototype.getInscription = function() {
    return this.javaObject.getInscriptionStr();
}


/**
 * Returns the place the arc ends in.
 */
OutputArc.prototype.getPlace = function() {
    return new Place(this.javaObject.getPlace());
}

/**
 * Returns the transition the arc starts from.
 */
OutputArc.prototype.getTransition = function() {
    if (this.javaObject.getTransition() instanceof Packages.gpal.TimedTransition)
        return new TimedTransition(this.javaObject.getTransition());
    if (this.javaObject.getTransition() instanceof Packages.gpal.ImmediateTransition)
        return new ImmediateTransition(this.javaObject.getTransition());
    if (this.javaObject.getTransition() instanceof Packages.gpal.SubstitutionTransition)
        return new SubstitutionTransition(this.javaObject.getTransition());
}
