// -*- java -*-
//
// $Id: ModuleInstance.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  ModuleInstance
// *************************************

/**
 * Creates a new ModuleInstance object.
 *
 * @param javaObject The java object to encapsulate.
 */
function ModuleInstance(javaObject) {
    if (javaObject == null) {
	session.throwException("ModuleInstance constructor: provided javaObject == null!");
    }
    this.javaObject = javaObject;
}


/**
 * Creates a temporary ModulePin and connects it with the given place.
 *
 * @param net The net to perform this operation in.
 * @param pinName The name of the pin to create, must match a SlavePlace's name of the ModuleDefinition.
 * @param place The Place to connect with.
 * @param inscription The inscription of the connection arc.
 * @return The new InputArc.
 */
ModuleInstance.prototype.connectInputPin = function(net, pinName, place, inscription) {
    var pin = new ModulePin(session.addModuleInputPin(net.javaObject, this.javaObject, pinName));
    
    return InputArc.add(net, place, pin, inscription);
}


/**
 * Creates a temporary ModulePin and connects it with the given place.
 *
 * @param net The net to perform this operation in.
 * @param pinName The name of the pin to create, must match a SlavePlace's name of the ModuleDefinition.
 * @param place The Place to connect with.
 * @param inscription The inscription of the connection arc.
 * @return The new OutputArc.
 */
ModuleInstance.prototype.connectOutputPin = function(net, pinName, place, inscription) {
    var pin = new ModulePin(session.addModuleOutputPin(net.javaObject, this.javaObject, pinName));
    
    return OutputArc.add(net, pin, place, inscription);
}


/**
 * Selects an implementation for this module instance.
 *
 * @param implName The name of the implementation to use.
 */
ModuleInstance.prototype.selectImplementation = function(implName) {
    session.selectModuleImplementation(this.javaObject, implName);
}


/** 
 * Sets the module parameter with the given name to the given value.
 *
 * @param name The name of the parameter to set.
 * @param value The value to set.
 */
ModuleInstance.prototype.setParameterValue = function(name, value) {
    if (name == null || name.equals("")) {
	session.throwExcpetion("ModuleInstance.setParameterValue: name of parameter is missing!");
    }
    if (value == null || value.equals("")) {
	session.throwExcpetion("ModuleInstance.setParameterValue: value of parameter is missing!");
    }

    session.setModuleParameter(this.javaObject, name, value);
}


/**
 * Returns the value of a value's parameter.
 * 
 * @param name The name of the parameter to get the value for.
 */
ModuleInstance.prototype.getParameterValue = function(name) {
    if (name == null || name.equals("")) {
	session.throwException("ModuleInstance.getParameterValue: name of parameter is missing!");
    }
    
    return session.getModuleParameter(this.javaObject, name);
}
