// -*- java -*-
//
// $Id: Module.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  Module
// *************************************

/**
 * Creates a new Module object.
 *
 * @param javaObject The java object to encapsulate.
 */
function Module(javaObject) {
    if (javaObject == null) {
	session.throwException("Module constructor: provided javaObject == null!");
    }
    this.javaObject = javaObject;
}


/**
 * Tries to find the module with the given name inside the net.
 *
 * @param net The net to search in.
 * @param name The name of the module.
 */
Module.withName = function(net, name) {
    if (net == null) {
	session.throwException("No net for Module.find!");
    }

    if (name == null) {
	session.throwException("No name for module referencing.");
    }
    
    return new Module(session.getModuleWithName(net.javaObject, name));
}


/**
 * Creates a new ModuleInstance for this Module Definition.
 *
 * @param net The net to create the module instance in.
 * @param instanceName The name of the new instance.
 * @return The ModuleInstance object.
 */
Module.prototype.createInstance = function(net, instanceName) {
    if (net == null) {
	session.throwException("No net for Module.find!");
    }
    if (instanceName == null) {
	session.throwException("No name for new instance provided.");
    }

    return new ModuleInstance(session.createModuleInstance(net.javaObject, this.javaObject, instanceName));
}
