// -*- java -*-
//
// $Id: Measure.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  Measure
// *************************************

/**
 * Creates a new Measure object.
 *
 * @param javaObject The java object to encapsulate.
 */
function Measure(javaObject) {
    if (javaObject == null) {
	session.throwException("Measure constructor: provided javaObject == null!");
    }
    this.javaObject = javaObject;
}


/**
 * Creates and adds a new Measure to the given net with the provided parameter values.
 *
 * @param net The net to add this measure to.
 * @param name The name of the new measure.
 * @param expression The expression to use.
 * @return The new Measure.
 */
Measure.add = function(net, name, expression) {
    if (net == null || name == null || expression == null) {
	session.throwExpression("Measure.add: No valid net, name or expression provided!");
    }

    return new Measure(session.addMeasure(net.javaObject, name, expression));
}


/**
 * Tries to find the Measure with the specified name in the provided net.
 *
 * @param net The net to search in.
 * @param name The name of the Measure to search.
 * @return The Measure, if found.
 */
Measure.withName = function(net, name) {
    if (name == null) {
	session.throwException("Measure.withName: provided name == null!");
    }
    
    return new Measure(session.getMeasureByName(net.javaObject, name));
}


/**
 * Returns this Measure's expression.
 * 
 * @return The measure's expression.
 */
Measure.prototype.getExpression = function() {
    return this.javaObject.getExpression().getExpressionStr();
}


/** 
 * Sets this measure's expression.
 *
 * @param expression The expression to set.
 */
Measure.prototype.setExpression = function(expression) {
    this.javaObject.setExpression(expression);
}
