// -*- java -*-
//
// $Id: Definition.js 10400 2007-08-07 23:38:00Z knoke $
//
// *************************************
//  Definition
// *************************************

/** 
 * Creates a new Definition with the given Java object.
 *
 * @param javaObject The javaObject to encapsulate.
 */
function Definition(javaObject) {
    if (javaObject == null) {
	session.throwException("Definition constructor: provided javaObject == null!");
    }
    this.javaObject = javaObject;
}

/**
 * This static method adds a new Definition to the given net with the given name
 * and expression.
 *
 * @param net The Petri Net to add the definition to.
 * @param name The name of this new definition.
 * @param expresison The expresison to use.
 * @return A new <code>Definition</code>
 */
Definition.add = function(net, name, expression) {
  if (net == null || name == null || expression == null) {
    session.throwException("Definition.add: No valid net, name or expresison provided!");
  }
  
  return new Definition(session.addDefinition(net.javaObject, name, expression));
}


/**
 * Tries to find the Definition with the given name.
 * 
 * @param net The Net to search in
 * @param name The name of the Definition to search.
 * @return The Definition, if found.
 */
Definition.withName = function(net, name) {
    if (name == null) {
	session.throwException("Definition.withName: provided name == null!");
    }
    
    return new Definition(session.getDefinitionByName(net.javaObject, name));
}


/**
 * Returns this definition's expression.
 * 
 * @return The expression of this Definition.
 */
Definition.prototype.getExpression = function() {
    return this.javaObject.getExpression().getExpressionStr();
}

/** 
 * Sets this definition's expression.
 *
 * @param expression The expression to set.
 */
Definition.prototype.setExpression = function(expression) {
    this.javaObject.setExpression(expression);
}
