/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.EBCDICWriter;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.TextWriter;
import nu.xom.TextWriterFactory;
import nu.xom.UnicodeWriter;
import nu.xom.UnsynchronizedBufferedWriter;
import nu.xom.XMLException;

public class Serializer {
    private TextWriter escaper;
    private boolean preserveBaseURI = false;

    public Serializer(OutputStream out) {
        try {
            this.setOutputStream(out, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("The VM is broken. It does not understand UTF-8.");
        }
    }

    public Serializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            throw new NullPointerException("Null encoding");
        }
        this.setOutputStream(out, encoding);
    }

    public void setOutputStream(OutputStream out) throws IOException {
        this.flush();
        int maxLength = this.getMaxLength();
        int indent = this.getIndent();
        String lineSeparator = this.getLineSeparator();
        boolean nfc = this.getUnicodeNormalizationFormC();
        String encoding = this.escaper.getEncoding();
        boolean lineSeparatorSet = this.escaper.lineSeparatorSet;
        this.setOutputStream(out, encoding);
        this.setIndent(indent);
        this.setMaxLength(maxLength);
        this.setUnicodeNormalizationFormC(nfc);
        if (lineSeparatorSet) {
            this.setLineSeparator(lineSeparator);
        }
    }

    private void setOutputStream(OutputStream out, String encoding) throws UnsupportedEncodingException {
        if (out == null) {
            throw new NullPointerException("Null OutputStream");
        }
        String encodingUpperCase = encoding.toUpperCase(Locale.ENGLISH);
        Writer writer = encodingUpperCase.equals("UTF-8") ? new OutputStreamWriter(out, "UTF-8") : (encodingUpperCase.equals("UTF-16") || encodingUpperCase.equals("ISO-10646-UCS-2") ? new OutputStreamWriter(out, "UnicodeBig") : (encodingUpperCase.equals("IBM037") || encodingUpperCase.equals("CP037") || encodingUpperCase.equals("EBCDIC-CP-US") || encodingUpperCase.equals("EBCDIC-CP-CA") || encodingUpperCase.equals("EBCDIC-CP-WA") || encodingUpperCase.equals("EBCDIC-CP-NL") || encodingUpperCase.equals("CSIBM037") ? new EBCDICWriter(out) : (encodingUpperCase.equals("ISO-8859-11") || encodingUpperCase.equals("TIS-620") ? new OutputStreamWriter(out, "TIS620") : new OutputStreamWriter(out, encoding))));
        writer = new UnsynchronizedBufferedWriter(writer);
        this.escaper = TextWriterFactory.getTextWriter(writer, encoding);
    }

    public void write(Document doc) throws IOException {
        this.escaper.reset();
        this.writeXMLDeclaration();
        int childCount = doc.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.writeChild(doc.getChild(i));
            this.escaper.breakLine();
        }
        this.escaper.flush();
    }

    protected void writeXMLDeclaration() throws IOException {
        this.escaper.writeMarkup("<?xml version=\"1.0\" encoding=\"");
        this.escaper.writeMarkup(this.escaper.getEncoding());
        this.escaper.writeMarkup("\"?>");
        this.escaper.breakLine();
    }

    protected void write(Element element) throws IOException {
        boolean wasPreservingWhiteSpace = this.escaper.isPreserveSpace();
        if (this.escaper.isIndenting() && !wasPreservingWhiteSpace && !this.escaper.justBroke()) {
            this.escaper.breakLine();
        }
        boolean hasRealChildren = false;
        int childCount = element.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Text t;
            Node child = element.getChild(i);
            if (child.isText() && (t = (Text)child).isEmpty()) continue;
            hasRealChildren = true;
            break;
        }
        if (hasRealChildren) {
            this.writeStartTag(element);
            String newXMLSpaceValue = element.getAttributeValue("space", "http://www.w3.org/XML/1998/namespace");
            if (newXMLSpaceValue != null) {
                if ("preserve".equals(newXMLSpaceValue)) {
                    this.escaper.setPreserveSpace(true);
                } else if ("default".equals(newXMLSpaceValue)) {
                    this.escaper.setPreserveSpace(false);
                }
            }
            this.escaper.incrementIndent();
            for (int i = 0; i < childCount; ++i) {
                Node child = element.getChild(i);
                if (this.escaper.getNFC() && child.isText()) {
                    Node next;
                    Text t = (Text)child;
                    while (i < childCount - 1 && (next = element.getChild(i + 1)).isText()) {
                        t = new Text(t.getValue() + next.getValue());
                        ++i;
                    }
                    this.writeChild(t);
                    continue;
                }
                this.writeChild(child);
            }
            this.escaper.decrementIndent();
            if (this.escaper.getIndent() > 0 && !this.escaper.isPreserveSpace() && this.hasNonTextChildren(element)) {
                this.escaper.breakLine();
            }
            this.writeEndTag(element);
            if (newXMLSpaceValue != null) {
                this.escaper.setPreserveSpace(wasPreservingWhiteSpace);
            }
        } else {
            this.writeEmptyElementTag(element);
        }
    }

    private boolean hasNonTextChildren(Element element) {
        int childCount = element.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (element.getChild(i).isText()) continue;
            return true;
        }
        return false;
    }

    protected void writeEndTag(Element element) throws IOException {
        this.escaper.writeMarkup("</");
        this.escaper.writeMarkup(element.getQualifiedName());
        this.escaper.writeMarkup('>');
    }

    protected void writeStartTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.writeMarkup('>');
    }

    protected void writeEmptyElementTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.writeMarkup("/>");
    }

    private void writeTagBeginning(Element element) throws IOException {
        this.escaper.writeMarkup('<');
        this.escaper.writeMarkup(element.getQualifiedName());
        this.writeAttributes(element);
        this.writeNamespaceDeclarations(element);
    }

    protected void writeAttributes(Element element) throws IOException {
        if (this.preserveBaseURI) {
            ParentNode parent = element.getParent();
            if (element.getAttribute("base", "http://www.w3.org/XML/1998/namespace") == null) {
                String baseValue = element.getBaseURI();
                if (parent == null || parent.isDocument() || !element.getBaseURI().equals(parent.getBaseURI())) {
                    this.escaper.writeMarkup(' ');
                    Attribute baseAttribute = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", baseValue);
                    this.write(baseAttribute);
                }
            }
        }
        int attributeCount = element.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute attribute = element.getAttribute(i);
            this.escaper.writeMarkup(' ');
            this.write(attribute);
        }
    }

    protected void writeNamespaceDeclarations(Element element) throws IOException {
        ParentNode parent = element.getParent();
        Map prefixes = element.getNamespacePrefixesInScope();
        Iterator iterator = prefixes.entrySet().iterator();
        while (iterator.hasNext()) {
            Element parentElement;
            Map.Entry entry = iterator.next();
            String additionalPrefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            if (parent != null && parent.isElement() ? uri.equals((parentElement = (Element)parent).getNamespaceURI(additionalPrefix)) : uri.equals("")) continue;
            this.escaper.writeMarkup(' ');
            this.writeNamespaceDeclaration(additionalPrefix, uri);
        }
    }

    protected void writeNamespaceDeclaration(String prefix, String uri) throws IOException {
        if ("".equals(prefix)) {
            this.escaper.writeMarkup("xmlns");
        } else {
            this.escaper.writeMarkup("xmlns:");
            this.escaper.writeMarkup(prefix);
        }
        this.escaper.writeMarkup("=\"");
        this.escaper.writePCDATA(uri);
        this.escaper.writeMarkup('\"');
    }

    protected void write(Attribute attribute) throws IOException {
        this.escaper.writeMarkup(attribute.getQualifiedName());
        this.escaper.writeMarkup("=\"");
        this.escaper.writeAttributeValue(attribute.getValue());
        this.escaper.writeMarkup('\"');
    }

    protected void write(Comment comment) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeMarkup("<!--");
        this.escaper.writeMarkup(comment.getValue());
        this.escaper.writeMarkup("-->");
    }

    protected void write(ProcessingInstruction instruction) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeMarkup("<?");
        this.escaper.writeMarkup(instruction.getTarget());
        String value = instruction.getValue();
        if (!"".equals(value)) {
            this.escaper.writeMarkup(' ');
            this.escaper.writeMarkup(value);
        }
        this.escaper.writeMarkup("?>");
    }

    protected void write(Text text) throws IOException {
        String value = text.getValue();
        if (text.isCDATASection() && value.indexOf("]]>") == -1) {
            if (!(this.escaper instanceof UnicodeWriter)) {
                int length = value.length();
                for (int i = 0; i < length; ++i) {
                    if (!this.escaper.needsEscaping(value.charAt(i))) continue;
                    this.escaper.writePCDATA(value);
                    return;
                }
            }
            this.escaper.writeMarkup("<![CDATA[");
            this.escaper.writeMarkup(value);
            this.escaper.writeMarkup("]]>");
        } else {
            if (this.isBoundaryWhitespace(text, value)) {
                return;
            }
            this.escaper.writePCDATA(value);
        }
    }

    private boolean isBoundaryWhitespace(Text text, String value) {
        if (this.getIndent() <= 0) {
            return false;
        }
        ParentNode parent = text.getParent();
        if (parent == null) {
            return "".equals(value.trim());
        }
        int childCount = parent.getChildCount();
        if (childCount == 1) {
            return false;
        }
        if (!"".equals(value.trim())) {
            return false;
        }
        int position = parent.indexOf(text);
        Node previous = null;
        Node next = null;
        if (position != 0) {
            previous = parent.getChild(position - 1);
        }
        if (position != childCount - 1) {
            next = parent.getChild(position + 1);
        }
        return !(previous != null && previous.isText() || next != null && next.isText());
    }

    protected void write(DocType doctype) throws IOException {
        this.escaper.writeMarkup("<!DOCTYPE ");
        this.escaper.writeMarkup(doctype.getRootElementName());
        if (doctype.getPublicID() != null) {
            this.escaper.writeMarkup(" PUBLIC \"" + doctype.getPublicID() + "\" \"" + doctype.getSystemID() + "\"");
        } else if (doctype.getSystemID() != null) {
            this.escaper.writeMarkup(" SYSTEM \"" + doctype.getSystemID() + "\"");
        }
        String internalDTDSubset = doctype.getInternalDTDSubset();
        if (!internalDTDSubset.equals("")) {
            this.escaper.writeMarkup(" [");
            this.escaper.breakLine();
            this.escaper.setInDocType(true);
            this.escaper.writeMarkup(internalDTDSubset);
            this.escaper.setInDocType(false);
            this.escaper.writeMarkup("]");
        }
        this.escaper.writeMarkup(">");
    }

    protected void writeChild(Node node) throws IOException {
        if (node.isElement()) {
            this.write((Element)node);
        } else if (node.isText()) {
            this.write((Text)node);
        } else if (node.isComment()) {
            this.write((Comment)node);
        } else if (node.isProcessingInstruction()) {
            this.write((ProcessingInstruction)node);
        } else if (node.isDocType()) {
            this.write((DocType)node);
        } else {
            throw new XMLException("Cannot write a " + node.getClass().getName() + " from the writeChild() method");
        }
    }

    protected final void writeEscaped(String text) throws IOException {
        this.escaper.writePCDATA(text);
    }

    protected final void writeAttributeValue(String value) throws IOException {
        this.escaper.writeAttributeValue(value);
    }

    protected final void writeRaw(String text) throws IOException {
        this.escaper.writeMarkup(text);
    }

    protected final void breakLine() throws IOException {
        this.escaper.breakLine();
    }

    public void flush() throws IOException {
        this.escaper.flush();
    }

    public int getIndent() {
        return this.escaper.getIndent();
    }

    public void setIndent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("Indent cannot be negative");
        }
        this.escaper.setIndent(indent);
    }

    public String getLineSeparator() {
        return this.escaper.getLineSeparator();
    }

    public void setLineSeparator(String lineSeparator) {
        this.escaper.setLineSeparator(lineSeparator);
    }

    public int getMaxLength() {
        return this.escaper.getMaxLength();
    }

    public void setMaxLength(int maxLength) {
        this.escaper.setMaxLength(maxLength);
    }

    public boolean getPreserveBaseURI() {
        return this.preserveBaseURI;
    }

    public void setPreserveBaseURI(boolean preserve) {
        this.preserveBaseURI = preserve;
    }

    public String getEncoding() {
        return this.escaper.getEncoding();
    }

    public void setUnicodeNormalizationFormC(boolean normalize) {
        this.escaper.setNFC(normalize);
    }

    public boolean getUnicodeNormalizationFormC() {
        return this.escaper.getNFC();
    }

    protected final int getColumnNumber() {
        return this.escaper.getColumnNumber();
    }
}

