/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Writer {
    private BufferedReader in;
    private PrintWriter out;
    private String[] buffer;
    private int nextChar;
    private int nextTokenLin;
    private int nextTokenCol;
    private int primLin;
    private int contLin;

    public Writer(String out) {
        try {
            this.out = new PrintWriter((java.io.Writer)new FileWriter(out), true);
            this.initBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public boolean isEndOfFile() {
        return this.nextTokenLin < 0;
    }

    public boolean isEndOfLine() {
        return this.nextTokenLin != this.primLin;
    }

    public String readLine() {
        if (this.contLin <= 0) {
            return null;
        }
        String line = this.buffer[this.primLin];
        if (this.nextChar > 0) {
            line = this.nextChar >= line.length() ? "" : line.substring(this.nextChar, line.length() - 1);
        }
        this.buffer[this.primLin] = null;
        this.nextChar = 0;
        ++this.primLin;
        --this.contLin;
        if (this.nextTokenLin >= 0 && this.nextTokenLin < this.primLin) {
            this.findNext();
        }
        return line;
    }

    public char readChar() {
        char newChar;
        if (this.contLin <= 0) {
            return '\u0000';
        }
        String line = this.buffer[this.primLin];
        if (this.nextChar >= line.length()) {
            newChar = '\n';
            this.readLine();
        } else if ((newChar = line.charAt(this.nextChar++)) != ' ' && this.nextTokenLin >= 0) {
            this.findNext();
        }
        return newChar;
    }

    public String readString() {
        String next = null;
        try {
            int i;
            this.checkEOF();
            String line = this.buffer[this.nextTokenLin];
            for (i = this.primLin; i < this.contLin; ++i) {
                this.buffer[i] = null;
            }
            this.buffer[0] = line;
            this.primLin = 0;
            this.nextTokenLin = 0;
            this.contLin = 1;
            int size = line.length();
            for (i = this.nextTokenCol; i < size && line.charAt(i) != ' '; ++i) {
            }
            next = line.substring(this.nextTokenCol, i);
            this.nextChar = i;
            this.findNext();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return next;
    }

    public int readInt() {
        return Integer.valueOf(this.readString());
    }

    public double readDouble() {
        return Double.valueOf(this.readString());
    }

    private void initBuffer() throws IOException {
        this.buffer = new String[5];
        this.nextChar = 0;
        this.nextTokenLin = 0;
        this.contLin = 0;
        this.primLin = 0;
    }

    private void checkEOF() throws EOFException {
        if (this.isEndOfFile()) {
            throw new EOFException();
        }
    }

    private int appendLine(String str) {
        if (this.contLin == 0) {
            this.primLin = 0;
        }
        if (this.primLin + this.contLin >= this.buffer.length) {
            String[] src = this.buffer;
            if (this.contLin >= this.buffer.length) {
                this.buffer = new String[2 * this.buffer.length];
            }
            System.arraycopy(src, this.primLin, this.buffer, 0, this.contLin);
            this.nextTokenLin -= this.primLin;
            this.primLin = 0;
        }
        this.buffer[this.primLin + this.contLin] = str;
        ++this.contLin;
        return this.primLin + this.contLin - 1;
    }

    private void findNext() {
        try {
            int i;
            int size;
            String line = this.buffer[this.primLin];
            if (line != null) {
                size = line.length();
                for (i = this.nextChar; i < size; ++i) {
                    if (line.charAt(i) == ' ') continue;
                    this.nextTokenCol = i;
                    return;
                }
            }
            this.nextTokenCol = -1;
            this.nextTokenLin = -1;
            while ((line = this.in.readLine()) != null) {
                size = line.length();
                for (i = 0; i < size; ++i) {
                    if (line.charAt(i) == ' ') continue;
                    this.nextTokenCol = i;
                    this.nextTokenLin = this.appendLine(line);
                    return;
                }
                this.appendLine(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void print(char c) {
        this.out.print(String.valueOf(c));
    }

    public void print(String s) {
        this.out.print(s);
    }

    public void print(int i) {
        this.out.print(i);
    }

    public void print(double d) {
        this.out.print(d);
    }

    public void print(double d, int dec) {
        this.out.print(this.formatDouble(d, dec));
    }

    public void println() {
        this.out.println();
    }

    public void println(char c) {
        this.out.println(String.valueOf(c));
    }

    public void println(String s) {
        this.out.println(s);
    }

    public void println(int i) {
        this.out.println(i);
    }

    public void println(double d) {
        this.out.println(d);
    }

    public void println(double d, int dec) {
        this.out.println(this.formatDouble(d, dec));
    }

    public void flush() {
        this.out.flush();
    }

    private String formatDouble(double d, int dec) {
        String num;
        int n;
        if (dec <= 0) {
            return String.valueOf(Math.round(d));
        }
        StringBuffer res = new StringBuffer();
        long aprox = (int)Math.round(d * Math.pow(10.0, dec));
        if (d < 0.0) {
            aprox = -aprox;
            res.append('-');
        }
        if ((n = (num = String.valueOf(aprox)).length() - dec) <= 0) {
            res.append("0.");
            for (int i = 0; i < -n; ++i) {
                res.append('0');
            }
            res.append(num);
        } else {
            char[] array = num.toCharArray();
            res.append(array, 0, n).append('.').append(array, n, dec);
        }
        return res.toString();
    }
}

