/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.control;

import com.gcap.randomvariategenerator.basics.randomvariatedistribution.RandomVariateGenerator;
import com.gcap.randomvariategenerator.control.DatasetCreator;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class ChartManipulator {
    private Chart chart;

    private void checkBounds(double minValue, double maxValue) throws IllegalArgumentException {
        if (minValue >= maxValue) {
            throw new IllegalArgumentException("Max value less or equal than Mix value");
        }
    }

    public JPanel createChartRandomVariate(RandomVariateGenerator randomVariateGenerator, int numBins, int maxSamples, boolean autorange) {
        this.checkBounds(randomVariateGenerator.getMinValue(), randomVariateGenerator.getMaxValue());
        JPanel result = null;
        DatasetCreator datasetCreator = DatasetCreator.getInstance();
        XYDataset dataset = datasetCreator.getDataSet(randomVariateGenerator, numBins, maxSamples, true);
        this.chart = new Chart(dataset, null, "Random Variate", randomVariateGenerator.isDiscrete());
        result = this.chart.getJPanelChart();
        return result;
    }

    public JPanel createChartProbabilityDistribution(RandomVariateGenerator randomVariateGenerator, int numBins, boolean autorange) {
        JPanel result = null;
        DatasetCreator datasetCreator = DatasetCreator.getInstance();
        this.checkBounds(randomVariateGenerator.getMinValue(), randomVariateGenerator.getMaxValue());
        if (autorange) {
            Range range = datasetCreator.getRange(randomVariateGenerator);
            randomVariateGenerator.setMaxValue(range.getUpperBound());
            randomVariateGenerator.setMinValue(range.getLowerBound());
        }
        XYDataset dataset = datasetCreator.getDataSet(randomVariateGenerator, numBins);
        this.chart = new Chart(dataset, null, "Probability Distrubution", randomVariateGenerator.isDiscrete());
        result = this.chart.getJPanelChart();
        return result;
    }

    public JPanel createChartProbabilityDistributionAndRandomVariate(RandomVariateGenerator randomVariateGenerator, int numBins, int maxSamples, boolean autorange) {
        JPanel result = null;
        DatasetCreator datasetCreator = DatasetCreator.getInstance();
        XYDataset dataset2 = datasetCreator.getDataSet(randomVariateGenerator, numBins, maxSamples, true);
        this.checkBounds(randomVariateGenerator.getMinValue(), randomVariateGenerator.getMaxValue());
        if (autorange) {
            Range range = DatasetUtilities.findDomainBounds((XYDataset)dataset2);
            randomVariateGenerator.setMaxValue(range.getUpperBound());
            randomVariateGenerator.setMinValue(range.getLowerBound());
        }
        XYDataset dataset1 = datasetCreator.getDataSet(randomVariateGenerator, numBins);
        this.chart = new Chart(dataset1, dataset2, "Probability Distrubution and Random Variate", randomVariateGenerator.isDiscrete());
        result = this.chart.getJPanelChart();
        return result;
    }

    private class Chart {
        private JFreeChart jFreeChar = null;
        private XYDataset xyDataSet1 = null;
        private XYDataset xyDataSet2 = null;

        public Chart(XYDataset dataset1, XYDataset dataset2, String name, boolean isDiscrete) {
            this.setXYDataSet1(dataset1);
            this.setXYDataSet2(dataset2);
            this.jFreeChar = ChartFactory.createXYLineChart((String)name, (String)"X", (String)"Y", (XYDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            this.jFreeChar.setBackgroundPaint((Paint)Color.white);
            XYPlot plot = (XYPlot)this.jFreeChar.getPlot();
            if (dataset2 != null) {
                plot.setDataset(1, dataset2);
                XYBarRenderer renderer2 = null;
                renderer2 = !isDiscrete ? new XYBarRenderer() : new XYBarRenderer();
                plot.setRenderer(1, (XYItemRenderer)renderer2);
            }
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
            plot.setBackgroundPaint((Paint)Color.lightGray);
            plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            plot.setDomainGridlinePaint((Paint)Color.white);
            plot.setRangeGridlinePaint((Paint)Color.white);
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
            renderer.setShapesVisible(isDiscrete);
            renderer.setLinesVisible(!isDiscrete);
            plot.getRangeAxis().setAutoRange(true);
            plot.setForegroundAlpha(0.75f);
        }

        public void setXYDataSet2(XYDataset xyDataSet2) {
            this.xyDataSet2 = xyDataSet2;
        }

        public void setXYDataSet1(XYDataset xyDataSet) {
            this.xyDataSet1 = xyDataSet;
        }

        public JFreeChart getJFreeChar() {
            return this.jFreeChar;
        }

        public JPanel getJPanelChart() {
            ChartPanel jpanelResult = new ChartPanel(this.getJFreeChar(), true, true, true, true, true);
            return jpanelResult;
        }
    }
}

