/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.basics.randomvariatedistribution;

import com.gcap.randomvariategenerator.basics.randomvariatedistribution.RandomVariateGenerator;

public class WeibullRandomVariateGenerator
extends RandomVariateGenerator {
    private double shape;
    private double scale;
    private double c;

    public WeibullRandomVariateGenerator(double minValue, double maxValue, double shape, double scale) {
        super(minValue, maxValue);
        if (shape <= 0.0) {
            shape = 1.0;
        }
        if (scale <= 0.0) {
            scale = 1.0;
        }
        this.shape = shape;
        this.scale = scale;
        this.c = shape / Math.pow(scale, shape);
    }

    public double generateRandomNumber() {
        return this.scale * Math.pow(-Math.log(Math.random()), 1.0 / this.shape);
    }

    public boolean isDiscrete() {
        return false;
    }

    public double getValue(double arg0) {
        return this.c * Math.pow(arg0, this.shape - 1.0) * Math.exp(-Math.pow(arg0 / this.scale, this.shape));
    }

    public double getCumulativeDistributionFunction(double x) {
        return 1.0 - Math.exp(-Math.pow(x / this.scale, this.shape));
    }
}

