/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.basics.randomvariatedistribution;

import com.gcap.randomvariategenerator.basics.randomvariatedistribution.RandomVariateGenerator;

public class ParetoRandomVariateGenerator
extends RandomVariateGenerator {
    private double shape;
    private double scale;
    private double inverseShape;

    public ParetoRandomVariateGenerator(double minValue, double maxValue, double shape, double scale) {
        super(minValue, maxValue);
        this.shape = shape;
        this.scale = scale;
        this.inverseShape = 1.0 / shape;
    }

    public double generateRandomNumber() {
        return this.scale / Math.pow(Math.random(), this.inverseShape);
    }

    public double getValue(double x) {
        double retorno = 0.0;
        retorno = x < this.scale ? 0.0 : this.shape * (Math.pow(this.scale, this.shape) / Math.pow(x, this.shape + 1.0));
        return retorno;
    }

    public boolean isDiscrete() {
        return false;
    }

    public double getCumulativeDistributionFunction(double x) {
        double result = 1.0 - Math.pow(this.scale / x, this.shape);
        return result;
    }
}

