/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.basics.randomvariatedistribution;

import com.gcap.randomvariategenerator.basics.randomvariatedistribution.RandomVariateGenerator;
import com.gcap.randomvariategenerator.util.Erf;
import com.gcap.randomvariategenerator.util.MathException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NormalRandomVariateGenerator
extends RandomVariateGenerator {
    private double average;
    private double variance;
    private double standardDeviation;
    private double saved;
    private boolean isSaved;
    public static final double SQRT2 = 1.4142135623730951;

    public NormalRandomVariateGenerator(double minValue, double maxValue, double average, double variance) {
        super(minValue, maxValue);
        this.average = average;
        this.variance = variance;
        this.standardDeviation = Math.sqrt(this.variance);
        this.saved = 0.0;
        this.isSaved = false;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public void setVariance(double variance) {
        this.variance = variance;
        this.setStandardDeviation(Math.sqrt(this.variance));
    }

    public void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
        this.setVariance(standardDeviation * standardDeviation);
    }

    public double generateRandomNumber() {
        double u = 0.0;
        double v = 0.0;
        double w = 0.0;
        double result = 0.0;
        if (this.isSaved) {
            result = this.saved;
            this.isSaved = false;
        } else {
            while ((w = (u = 2.0 * Math.random() - 1.0) * u + (v = 2.0 * Math.random() - 1.0) * v) > 1.0) {
            }
            w = Math.sqrt(-2.0 * Math.log(w) / w);
            this.saved = u * w * this.standardDeviation + this.average;
            this.isSaved = true;
            result = v * w * this.standardDeviation + this.average;
        }
        return result;
    }

    public double getValue(double x) {
        return Math.exp(-1.0 * (x - this.average) * (x - this.average) / (2.0 * this.standardDeviation * this.standardDeviation)) / Math.sqrt(Math.PI * 2 * this.standardDeviation * this.standardDeviation);
    }

    public boolean isDiscrete() {
        return false;
    }

    public double getCumulativeDistributionFunction(double x) {
        double retorno = 0.0;
        try {
            retorno = 0.5 * (1.0 + Erf.erf((x - this.average) / (this.standardDeviation * 1.4142135623730951)));
        }
        catch (MathException ex) {
            Logger.getLogger(NormalRandomVariateGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(NormalRandomVariateGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return retorno;
    }
}

