/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.basics.randomvariatedistribution;

import com.gcap.randomvariategenerator.basics.randomvariatedistribution.RandomVariateGenerator;

public class ExponentialRandomVariateGenerator
extends RandomVariateGenerator {
    private double rateParameter;

    public double getRateParameter() {
        return this.rateParameter;
    }

    public ExponentialRandomVariateGenerator(double minValue, double maxValue, double rate) {
        super(minValue, maxValue);
        this.rateParameter = rate;
    }

    public double generateRandomNumber() {
        double result = -(Math.log(1.0 - Math.random()) / this.rateParameter);
        if (result < this.getMinValue()) {
            result = this.getMinValue();
        } else if (result > this.getMaxValue()) {
            result = this.getMaxValue();
        }
        return result;
    }

    public double getValue(double x) {
        return this.rateParameter * Math.pow(Math.E, -(this.rateParameter * x));
    }

    public double getCumulativeDistributionFunction(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-x * this.rateParameter);
    }

    public boolean isDiscrete() {
        return false;
    }
}

