/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.tokengame;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;
import org.modcs.tools.spn.gui.graphview.IconImpl;
import org.modcs.tools.spn.model.Place;
import org.modcs.tools.spn.model.TransitionExponential;
import org.modcs.tools.spn.model.TransitionImmediate;
import org.modcs.tools.spn.simulator.tokengame.ComponentsBlinker;
import org.modcs.tools.spn.simulator.tokengame.TransitionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenGameManager
implements TransitionListener {
    private JGraph graph = null;
    private ComponentsBlinker cb = null;
    private HashMap<CellView, Integer> placesCardinalities = null;

    public TokenGameManager(JGraph graph) {
        this.graph = graph;
    }

    public void start() {
        this.graph.setEnabled(false);
        this.savePlacesCardinalities();
        this.cb = new ComponentsBlinker(this.graph, this.getFireables(), this);
        this.cb.start();
    }

    public void stop() {
        this.cb.stop();
        this.restorePlacesCardinalities();
        this.graph.setEnabled(true);
    }

    private void savePlacesCardinalities() {
        this.placesCardinalities = new HashMap();
        CellView[] cellViews = this.graph.getGraphLayoutCache().getCellViews();
        for (int x = 0; x < cellViews.length; ++x) {
            CellView cv = cellViews[x];
            DefaultGraphCell gc = (DefaultGraphCell)cv.getCell();
            Object userObject = gc.getUserObject();
            if (!(userObject instanceof Place)) continue;
            Place p = (Place)userObject;
            this.placesCardinalities.put(cv, p.getMarking());
        }
    }

    private void restorePlacesCardinalities() {
        CellView[] cellViews = this.graph.getGraphLayoutCache().getCellViews();
        for (int x = 0; x < cellViews.length; ++x) {
            CellView cv = cellViews[x];
            DefaultGraphCell gc = (DefaultGraphCell)cv.getCell();
            Object userObject = gc.getUserObject();
            if (!(userObject instanceof Place)) continue;
            Place p = (Place)userObject;
            p.setMarking(this.placesCardinalities.get(cv));
            Icon icon = this.getIcon(p.getMarking());
            GraphConstants.setIcon((Map)gc.getAttributes(), (Icon)icon);
            this.graph.getGraphLayoutCache().editCell((Object)gc, (Map)gc.getAttributes());
        }
    }

    private ArrayList<CellView> getFireables() {
        CellView[] cellViews = this.graph.getGraphLayoutCache().getCellViews();
        ArrayList<CellView> cellsExponential = new ArrayList<CellView>();
        ArrayList<CellView> cellsImmHighPriority = new ArrayList<CellView>();
        int maxPriority = -1;
        for (int x = 0; x < cellViews.length; ++x) {
            CellView cv = cellViews[x];
            DefaultGraphCell gc = (DefaultGraphCell)cv.getCell();
            Object userObject = gc.getUserObject();
            try {
                TransitionImmediate transition;
                if (userObject instanceof TransitionExponential) {
                    TransitionExponential t = (TransitionExponential)userObject;
                    if (!t.canFire()) continue;
                    cellsExponential.add(cv);
                    continue;
                }
                if (!(userObject instanceof TransitionImmediate) || !(transition = (TransitionImmediate)userObject).canFire()) continue;
                if (transition.getPriority() > maxPriority) {
                    maxPriority = transition.getPriority();
                    cellsImmHighPriority.clear();
                    cellsImmHighPriority.add(cv);
                    continue;
                }
                if (transition.getPriority() != maxPriority) continue;
                cellsImmHighPriority.add(cv);
                continue;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.toString());
            }
        }
        if (cellsImmHighPriority.size() == 0) {
            return cellsExponential;
        }
        return cellsImmHighPriority;
    }

    @Override
    public void transitionFired(CellView cv) {
        DefaultGraphCell cell = (DefaultGraphCell)cv.getCell();
        Object userObject = cell.getUserObject();
        if (userObject instanceof TransitionExponential) {
            TransitionExponential transition = (TransitionExponential)userObject;
            transition.fire();
            this.switchTokens(cv);
        } else if (userObject instanceof TransitionImmediate) {
            TransitionImmediate transition = (TransitionImmediate)userObject;
            transition.fire();
            this.switchTokens(cv);
        }
        this.cb.reload(this.getFireables());
    }

    private void switchTokens(CellView cv) {
        Object transition = cv.getCell();
        GraphModel model = this.graph.getModel();
        ArrayList<DefaultEdge> edges = new ArrayList<DefaultEdge>();
        int numChildren = model.getChildCount(transition);
        for (int i = 0; i < numChildren; ++i) {
            Object port = model.getChild(transition, i);
            if (!model.isPort(port)) continue;
            Iterator iter = model.edges(port);
            while (iter.hasNext()) {
                edges.add((DefaultEdge)iter.next());
            }
        }
        for (DefaultEdge edge : edges) {
            Icon icon;
            Place place;
            Port sourcePort = (Port)edge.getSource();
            Port targetPort = (Port)edge.getTarget();
            if (model.getParent((Object)sourcePort) == transition) {
                DefaultGraphCell child = (DefaultGraphCell)model.getParent((Object)targetPort);
                place = (Place)child.getUserObject();
                icon = this.getIcon(place.getMarking());
                GraphConstants.setIcon((Map)child.getAttributes(), (Icon)icon);
                this.graph.getGraphLayoutCache().editCell((Object)child, (Map)child.getAttributes());
                continue;
            }
            if (model.getParent((Object)targetPort) != transition) continue;
            DefaultGraphCell parent = (DefaultGraphCell)model.getParent((Object)sourcePort);
            place = (Place)parent.getUserObject();
            icon = this.getIcon(place.getMarking());
            GraphConstants.setIcon((Map)parent.getAttributes(), (Icon)icon);
            this.graph.getGraphLayoutCache().editCell((Object)parent, (Map)parent.getAttributes());
        }
    }

    private Icon getIcon(int numberTokens) {
        ImageIcon icon = null;
        icon = numberTokens < 4 ? new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/" + numberTokens + "Place.png")) : new IconImpl(this.getClass().getResource("/org/modcs/tools/gui/icons/0Place.png"), "" + numberTokens);
        return icon;
    }
}

