/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.randomvariates;

import org.modcs.tools.Util.Util;
import org.modcs.tools.spn.simulator.randomvariates.RandomVariateGenerator;

public class PoissonRandomVariateGenerator
implements RandomVariateGenerator {
    private double rate;

    public PoissonRandomVariateGenerator(double rate) {
        if (rate < 0.0) {
            rate = 1.0;
        }
        this.rate = rate;
    }

    public double generateRandomNumber(double delay) {
        this.rate = 1.0 / delay;
        int arrivals = 0;
        for (double sum = -Math.log(1.0 - Math.random()); sum <= this.rate; sum -= Math.log(1.0 - Math.random())) {
            ++arrivals;
        }
        return arrivals;
    }

    public boolean isDiscrete() {
        return true;
    }

    public double getValue(double arg0) {
        int k = (int)Math.rint(arg0);
        if (this.rate == 0.0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (k < 0) {
            return 0.0;
        }
        return Math.exp(-this.rate + (double)k * Math.log(this.rate) - Util.logGamma(k + 1));
    }

    public double getDelay() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

