/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.randomvariates;

import org.modcs.tools.spn.simulator.randomvariates.RandomVariateGenerator;

public class GeometricRandomVariateGenerator
implements RandomVariateGenerator {
    private double sucessProbability;
    private double denominator;

    public GeometricRandomVariateGenerator(double sucessProbability) throws IllegalArgumentException {
        if (sucessProbability > 1.0) {
            throw new IllegalArgumentException("The parameter must be less than 1");
        }
        this.sucessProbability = sucessProbability;
        this.denominator = Math.log(1.0 - sucessProbability);
    }

    public double generateRandomNumber(double delay) {
        throw new UnsupportedOperationException();
    }

    public double getValue(double x) {
        int intx = (int)Math.rint(x);
        return Math.pow(1.0 - this.sucessProbability, intx) * this.sucessProbability;
    }

    public boolean isDiscrete() {
        return true;
    }

    public double getDelay() {
        throw new UnsupportedOperationException();
    }
}

