/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.outputanalisys;

public class StudentTDistribution {
    private int degrees;
    private double c;
    protected static final double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};

    public StudentTDistribution(int n) {
        this.setDegrees(n);
    }

    public StudentTDistribution() {
        this(1);
    }

    public static double logGamma(double xx) {
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        double[] coeff = cof;
        for (int j = 0; j <= 5; ++j) {
            ser += coeff[j] / (x += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * ser);
    }

    public static double betaCDF(double x, double a, double b) {
        double bt = x == 0.0 | x == 1.0 ? 0.0 : Math.exp(StudentTDistribution.logGamma(a + b) - StudentTDistribution.logGamma(a) - StudentTDistribution.logGamma(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return bt * StudentTDistribution.betaCF(x, a, b) / a;
        }
        return 1.0 - bt * StudentTDistribution.betaCF(1.0 - x, b, a) / b;
    }

    private static double betaCF(double x, double a, double b) {
        int maxit = 100;
        double eps = 3.0E-7;
        double am = 1.0;
        double bm = 1.0;
        double az = 1.0;
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double bz = 1.0 - qab * x / qap;
        for (int m = 1; m <= maxit; ++m) {
            double em = m;
            double tem = em + em;
            double d = em * (b - (double)m) * x / ((qam + tem) * (a + tem));
            double ap = az + d * am;
            double bp = bz + d * bm;
            d = -(a + em) * (qab + em) * x / ((a + tem) * (qap + tem));
            double app = ap + d * az;
            double bpp = bp + d * bz;
            double aOld = az;
            am = ap / bpp;
            bm = bp / bpp;
            az = app / bpp;
            bz = 1.0;
            if (Math.abs(az - aOld) < eps * Math.abs(az)) break;
        }
        return az;
    }

    public void setDegrees(int n) {
        if (n < 1) {
            n = 1;
        }
        this.degrees = n;
        this.c = StudentTDistribution.logGamma(0.5 * (double)(this.degrees + 1)) - 0.5 * Math.log(this.degrees) - 0.5 * Math.log(Math.PI) - StudentTDistribution.logGamma(0.5 * (double)this.degrees);
    }

    public double getDensity(double x) {
        return Math.exp(this.c - 0.5 * (double)(this.degrees + 1) * Math.log(1.0 + x * x / (double)this.degrees));
    }

    public double getMaxDensity() {
        return this.getDensity(0.0);
    }

    public double getCDF(double x) {
        double u = (double)this.degrees / ((double)this.degrees + x * x);
        if (x > 0.0) {
            return 1.0 - 0.5 * StudentTDistribution.betaCDF(u, 0.5 * (double)this.degrees, 0.5);
        }
        return 0.5 * StudentTDistribution.betaCDF(u, 0.5 * (double)this.degrees, 0.5);
    }

    protected double findRoot(double prob, double guess, double xLo, double xHi) {
        if (prob < 0.0 || 1.0 < prob) {
            return 0.0;
        }
        if (xLo > guess || guess > xHi) {
            return 0.0;
        }
        double accuracy = 1.0E-7;
        int maxIteration = 150;
        double x = guess;
        double xNew = guess;
        double dx = 1000.0;
        int i = 0;
        while (Math.abs(dx) > 1.0E-7 && i++ < 150) {
            double error = this.getCDF(x) - prob;
            if (error < 0.0) {
                xLo = x;
            } else {
                xHi = x;
            }
            double pdf = this.getDensity(x);
            if (pdf != 0.0) {
                dx = error / pdf;
                xNew = x - dx;
            }
            if (xNew < xLo || xNew > xHi || pdf == 0.0) {
                xNew = (xLo + xHi) / 2.0;
                dx = xNew - x;
            }
            x = xNew;
        }
        return x;
    }

    public double inverseCDF(double probability) {
        if (0.0 <= probability && probability <= 1.0) {
            return this.findRoot(probability, -1.0, -6.0, 6.0);
        }
        if (probability < 0.0) {
            return 0.0;
        }
        return 1.0;
    }

    public double getDegrees() {
        return this.degrees;
    }
}

