/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.entities;

import org.modcs.tools.spn.model.Transition;
import org.modcs.tools.spn.model.TransitionExponential;
import org.modcs.tools.spn.model.TransitionImmediate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SELComponentModel
implements Comparable<SELComponentModel> {
    Transition transition;
    double time;

    public SELComponentModel(Transition transition, double time) {
        this.transition = transition;
        this.time = time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public double getTime() {
        return this.time;
    }

    @Override
    public int compareTo(SELComponentModel param) {
        int result = 0;
        if (this.getTransition() instanceof TransitionExponential && param.getTransition() instanceof TransitionExponential) {
            result = (int)Math.signum(this.getTime() - param.getTime());
        }
        if (this.getTransition() instanceof TransitionImmediate && param.getTransition() instanceof TransitionImmediate) {
            TransitionImmediate tThis = (TransitionImmediate)this.getTransition();
            TransitionImmediate tParam = (TransitionImmediate)param.getTransition();
            result = (int)Math.signum(tParam.getPriority() - tThis.getPriority());
        } else if (this.getTransition() instanceof TransitionExponential && param.getTransition() instanceof TransitionImmediate) {
            result = 1;
        }
        if (this.getTransition() instanceof TransitionImmediate && param.getTransition() instanceof TransitionExponential) {
            result = -1;
        }
        return result;
    }

    public boolean equals(SELComponentModel eventTime) {
        boolean result = false;
        if (eventTime.getTransition().getName().equals(this.transition.getName())) {
            result = true;
        }
        return result;
    }

    public SELComponentModel clone() throws CloneNotSupportedException {
        return new SELComponentModel(this.transition, this.time);
    }
}

