/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.engine;

import java.util.ArrayList;
import org.modcs.tools.spn.model.Transition;
import org.modcs.tools.spn.simulator.engine.FireCounterElement;

public class FireCounter {
    private ArrayList<FireCounterElement> fireCounterElements = new ArrayList();
    private int numberTransitions;
    private int minFireForEachTrasition;
    private int numberTransitionsReachMin;

    public FireCounter(int numberTransitions, int minFireForEachTrasition) {
        this.numberTransitions = numberTransitions;
        this.minFireForEachTrasition = minFireForEachTrasition;
        this.numberTransitionsReachMin = 0;
    }

    public void setNumberTransitions(int numberTransitions) {
        this.numberTransitions = numberTransitions;
    }

    public void update(Transition transition) {
        FireCounterElement fireCounterElement = new FireCounterElement(transition, this.minFireForEachTrasition);
        int i = this.fireCounterElements.indexOf(fireCounterElement);
        if (i == -1) {
            this.fireCounterElements.add(fireCounterElement);
            fireCounterElement.update();
        } else if (!this.fireCounterElements.get(i).isReachMinimum()) {
            this.fireCounterElements.get(i).update();
            if (this.fireCounterElements.get(i).isReachMinimum()) {
                ++this.numberTransitionsReachMin;
            }
        }
    }

    public boolean isAllTransitionsReachMinFires() {
        return this.numberTransitionsReachMin >= this.numberTransitions || this.minFireForEachTrasition == 0;
    }
}

