/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.modcs.tools.spn.experiment.ExperimentEngine;
import org.modcs.tools.spn.gui.JDialogSimulationOutput;
import org.modcs.tools.spn.gui.graphview.ChartTransient;
import org.modcs.tools.spn.model.EDSPN;
import org.modcs.tools.spn.model.Transition;
import org.modcs.tools.spn.model.expressions.LogicCondition;
import org.modcs.tools.spn.simulator.engine.FireCounter;
import org.modcs.tools.spn.simulator.engine.ScheduledEventList;
import org.modcs.tools.spn.simulator.engine.StationaryParameters;
import org.modcs.tools.spn.simulator.engine.TransientConfidenceList;
import org.modcs.tools.spn.simulator.engine.TransientParameters;
import org.modcs.tools.spn.simulator.entities.InterfaceModelGenerator;
import org.modcs.tools.spn.simulator.entities.SELComponentModel;
import org.modcs.tools.spn.simulator.outputanalisys.DataAnalyzer;
import org.modcs.tools.spn.simulator.randomvariates.ExponentialRandomVariateGenerator;

public class Engine {
    private ScheduledEventList scheduledEventList;
    private DataAnalyzer dataAnalyzerInterRuns;
    private EDSPN model;
    private int expectedRuns;
    private InterfaceModelGenerator modelGenerator;
    private int runSize;
    private double confidenceLevel;
    private double error;
    private int counterIntraRun;
    private int counterInterRun = 0;
    private FireCounter fireCounter;
    private int minNumberFiresForEachTransition;
    private int warmUpPeriod;
    private long startTime;
    private long maxTime;
    private JDialogSimulationOutput jDialogSimulationOutput;
    private long maxSimulationTime;
    private long samplingPoints;
    private File fileOutputTransient;
    private TransientConfidenceList transientConfidenceList;
    private double currentSimulationTime;
    private ArrayList<Transition> feasiblesEvents;
    private SELComponentModel selComponentActual;
    private int currentIndexTransientSimulation;
    private boolean calculateMTTF;
    private double meanTimeToFailure;
    private double meanTimeToRepair;
    private boolean experiment;
    private ExperimentEngine.TaskStationaty taskStationaty;
    private ExperimentEngine.TaskTransient taskTransient;
    private String text;
    private double firstError = Double.NEGATIVE_INFINITY;

    public Engine() {
        this.dataAnalyzerInterRuns = new DataAnalyzer();
    }

    public Engine(InterfaceModelGenerator interfaceModelGenerator) {
        this();
        this.modelGenerator = interfaceModelGenerator;
    }

    public int getCounterRuns() {
        return this.counterInterRun;
    }

    public int getRunSize() {
        return this.runSize;
    }

    public ExperimentEngine.TaskStationaty getTaskStationaty() {
        return this.taskStationaty;
    }

    public void setTaskStationaty(ExperimentEngine.TaskStationaty taskStationaty) {
        this.taskStationaty = taskStationaty;
    }

    public void initRun() throws Exception {
        this.model = this.modelGenerator.generateModel();
        this.scheduledEventList = new ScheduledEventList();
        this.counterIntraRun = 0;
        this.feasiblesEvents = this.model.getFeasibles();
        this.selComponentActual = this.scheduledEventList.updateList(this.feasiblesEvents, 0.0);
    }

    public void initRunStationary() throws Exception {
        this.initRun();
        this.fireCounter = new FireCounter(this.model.getTransitions().size(), this.minNumberFiresForEachTransition);
        ExponentialRandomVariateGenerator.getInstance().restartSeed();
    }

    public void initRunTransient() throws Exception {
        this.initRun();
        this.currentSimulationTime = 0.0;
        this.currentIndexTransientSimulation = 0;
        ExponentialRandomVariateGenerator.getInstance().restartSeed();
    }

    public String getText() {
        return this.text;
    }

    public void outputText(String message) {
        if (!this.experiment) {
            this.text = message + "\n";
            if (this.dataAnalyzerInterRuns != null) {
                if (this.taskStationaty != null) {
                    this.taskStationaty.setProgresso(this.counterInterRun);
                } else if (this.taskTransient != null) {
                    double errorTemp = this.transientConfidenceList.getMaximumError();
                    if (this.firstError != Double.NEGATIVE_INFINITY && this.firstError != 0.0 && errorTemp > 0.0) {
                        int prog = 100 - (int)(100.0 * (errorTemp - this.error) / (this.firstError - this.error));
                        if (prog >= 100) {
                            prog = 99;
                        }
                        this.taskTransient.setProgresso(prog);
                    }
                }
            }
        }
    }

    public void initOutputScreen(String message) {
        if (!this.experiment) {
            this.outputText("");
            this.outputText(message);
            this.outputText("");
        }
    }

    public void printTime() {
        long miliseconds = System.currentTimeMillis() - this.startTime;
        int seconds = (int)(miliseconds / 1000L % 60L);
        int minutes = (int)(miliseconds / 1000L / 60L % 60L);
        int hours = (int)(miliseconds / 1000L / 60L / 60L);
        this.outputText("Time Spend: " + hours + " hour(s) " + minutes + " minutes(s) " + seconds + " second(s) ");
    }

    public void printFile(TransientParameters transientParameters) throws FileNotFoundException {
        ArrayList<Double> doubles = new ArrayList<Double>();
        FileOutputStream out = new FileOutputStream(this.fileOutputTransient);
        PrintWriter p = new PrintWriter(out);
        int i = 0;
        while ((long)i < this.samplingPoints) {
            DataAnalyzer dataAnalyzer = this.transientConfidenceList.getDataAnalyzerByIndex(i);
            p.print("Time: " + transientParameters.getSlotSize() * (double)(i + 1));
            p.print("\tMean: " + dataAnalyzer.getMean());
            p.print("\tCI: [" + dataAnalyzer.getLowerBoundConfidenceInterval() + "," + dataAnalyzer.getUpperBoundConfidenceInterval() + "]");
            p.println("\tError: " + this.transientConfidenceList.getErrorByIndex(i));
            doubles.add(new Double(dataAnalyzer.getMean()));
            ++i;
        }
        ChartTransient chartTransient = new ChartTransient();
        JFrame jFrame = new JFrame("Reliability Values");
        jFrame.add(chartTransient.getChart(doubles, transientParameters.getSlotSize()));
        jFrame.setLocationRelativeTo(this.jDialogSimulationOutput);
        jFrame.pack();
        jFrame.setVisible(true);
        if (this.calculateMTTF) {
            double MTTFValue = this.generateMTTF(transientParameters);
            p.println();
            p.println("MTTF = " + MTTFValue);
            this.outputText("MTTF = " + MTTFValue);
        }
        p.close();
    }

    public double generateMTTF(TransientParameters transientParameters) {
        double currentValue = 0.0;
        double MTTF = 0.0;
        int i = 0;
        while ((long)i < this.samplingPoints) {
            DataAnalyzer dataAnalyzer = this.transientConfidenceList.getDataAnalyzerByIndex(i);
            if (i == 0) {
                currentValue = dataAnalyzer.getMean();
            } else {
                double nextValue = dataAnalyzer.getMean();
                double media = (currentValue + nextValue) / 2.0;
                MTTF += (media *= Double.parseDouble(String.valueOf(transientParameters.getMaxSimulationTime())) / (double)transientParameters.getSamplingPoints());
                currentValue = nextValue;
            }
            ++i;
        }
        this.meanTimeToFailure = MTTF + 1.0;
        return MTTF;
    }

    public void runTransient(TransientParameters transientParameters) throws Exception {
        this.confidenceLevel = transientParameters.getConfidenceLevel();
        this.error = transientParameters.getMaxRelativeError();
        this.maxTime = transientParameters.getMaxTimeMilliseconds();
        this.maxSimulationTime = transientParameters.getMaxSimulationTime();
        this.samplingPoints = transientParameters.getSamplingPoints();
        this.fileOutputTransient = transientParameters.getFile();
        this.startTime = System.currentTimeMillis();
        this.expectedRuns = 50;
        this.calculateMTTF = transientParameters.getCalculateMTTF();
        this.transientConfidenceList = new TransientConfidenceList((int)this.samplingPoints, this.confidenceLevel, this.error);
        this.initOutputScreen("New Transient Simulation ......");
        this.initRunTransient();
        double slotSize = transientParameters.getSlotSize();
        double timeSpend = 0.0;
        do {
            if (this.selComponentActual != null) {
                timeSpend = this.selComponentActual.getTime();
            }
            double restActualSlot = this.currentSimulationTime % slotSize;
            int numberSlotsAdvanced = (int)Math.floor((timeSpend + restActualSlot) / slotSize);
            LogicCondition logicCondition = this.model.getRewardMeasures().get(0).getExpression().getRealValue().getRewItem().getProbability().getLogicCondition();
            if (numberSlotsAdvanced > 0) {
                double restSlot = timeSpend;
                restSlot -= slotSize - restActualSlot;
                this.updateMetrics(slotSize - restActualSlot);
                boolean eval = logicCondition.evaluate();
                this.transientConfidenceList.update(eval, this.currentIndexTransientSimulation);
                ++this.currentIndexTransientSimulation;
                for (int i = 1; i < numberSlotsAdvanced && (double)this.currentIndexTransientSimulation * slotSize < (double)this.maxSimulationTime; ++i) {
                    restSlot -= slotSize;
                    this.updateMetrics(slotSize);
                    this.transientConfidenceList.update(eval, this.currentIndexTransientSimulation);
                    ++this.currentIndexTransientSimulation;
                }
                this.updateMetrics(restSlot);
            } else {
                this.updateMetrics(timeSpend);
            }
            this.currentSimulationTime += timeSpend;
            if (this.selComponentActual == null) continue;
            this.selComponentActual.getTransition().fire();
            this.feasiblesEvents = this.model.getFeasibles();
            this.selComponentActual = this.scheduledEventList.updateList(this.feasiblesEvents, timeSpend);
        } while (!this.canStopTransient());
        this.printFile(transientParameters);
        this.printTime();
        this.taskTransient.setProgresso(100);
    }

    public void runStationary(StationaryParameters stationaryParameters) throws Exception {
        this.confidenceLevel = stationaryParameters.getConfidenceLevel();
        this.error = stationaryParameters.getMaxRelativeError();
        this.minNumberFiresForEachTransition = stationaryParameters.getMinFiringTransitions();
        this.warmUpPeriod = stationaryParameters.getWarmUpPeriod();
        this.runSize = stationaryParameters.getRunSize();
        this.maxTime = stationaryParameters.getMaxTimeMilliseconds();
        this.startTime = System.currentTimeMillis();
        this.initOutputScreen("New Stationary Simulation......");
        this.initRunStationary();
        do {
            double timeSpend = this.selComponentActual.getTime();
            this.fireCounter.update(this.selComponentActual.getTransition());
            this.updateMetrics(this.selComponentActual);
            this.selComponentActual.getTransition().fire();
            this.feasiblesEvents = this.model.getFeasibles();
            this.selComponentActual = this.scheduledEventList.updateList(this.feasiblesEvents, timeSpend);
        } while (!this.canStopStationary());
        this.printTime();
        if (this.taskStationaty != null) {
            this.taskStationaty.setMaximum();
        }
    }

    public void updateMetrics(SELComponentModel selComponentActual) throws Exception {
        this.model.updateMetrics(selComponentActual.getTime());
    }

    public void updateMetrics(double time) throws Exception {
        this.model.updateMetrics(time);
    }

    public double getMetric() throws Exception {
        double metric = this.model.getMetrics().get(0);
        return metric;
    }

    public boolean canStopStationary() throws Exception {
        boolean result = false;
        ++this.counterIntraRun;
        if (this.counterIntraRun >= this.runSize && this.fireCounter.isAllTransitionsReachMinFires()) {
            double errorTemp;
            ++this.counterInterRun;
            double metric = this.getMetric();
            this.dataAnalyzerInterRuns.update(metric);
            if (this.counterInterRun == this.expectedRuns) {
                this.expectedRuns = (int)Math.ceil(this.dataAnalyzerInterRuns.getReplications(this.confidenceLevel, this.error));
            }
            if (this.counterInterRun > 1) {
                this.outputText("Count: " + this.counterInterRun + "\tError: " + this.dataAnalyzerInterRuns.getError(this.confidenceLevel) + "\tMetric: " + metric);
            } else {
                this.outputText("\tMetric: " + metric);
            }
            this.initRunStationary();
            if (this.counterInterRun >= this.warmUpPeriod && (errorTemp = this.dataAnalyzerInterRuns.getError(this.confidenceLevel)) < this.error) {
                result = true;
            }
        }
        if (this.maxTime > 0L && System.currentTimeMillis() - this.startTime > this.maxTime) {
            this.outputText("***********************************************************************************");
            this.outputText("the maximum time of simulation was achieved,\nthe desired error may not have been found");
            this.outputText("***********************************************************************************");
            result = true;
        }
        return result;
    }

    private boolean canStopTransient() throws Exception {
        boolean result = false;
        if (this.currentSimulationTime >= (double)this.maxSimulationTime) {
            ++this.counterInterRun;
            if (this.counterInterRun > 1) {
                this.outputText("Count: " + this.counterInterRun + "\tError: " + this.transientConfidenceList.getMaximumError());
            }
            if (this.counterInterRun >= this.expectedRuns) {
                if (this.counterInterRun == this.expectedRuns) {
                    this.expectedRuns = (int)Math.ceil(this.transientConfidenceList.getMaximumReplications());
                }
                double errorTemp = this.transientConfidenceList.getMaximumError();
                if (this.firstError == Double.NEGATIVE_INFINITY || this.firstError == 0.0) {
                    this.firstError = errorTemp;
                }
                if (errorTemp < this.error) {
                    result = true;
                }
            }
            this.initRunTransient();
            this.transientConfidenceList.resetMaximumError();
            this.transientConfidenceList.resetMaximumReplications();
        }
        if (this.maxTime > 0L && System.currentTimeMillis() - this.startTime > this.maxTime) {
            this.outputText("***********************************************************************************");
            this.outputText("the maximum time of simulation was achieved,\nthe desired error may not have been found");
            this.outputText("***********************************************************************************");
            result = true;
        }
        return result;
    }

    public double getResult() {
        return this.dataAnalyzerInterRuns.getMean();
    }

    public String getResults() {
        double nines = 2.0 - Math.log(100.0 - this.dataAnalyzerInterRuns.getMean() * 100.0) / Math.log(10.0);
        return "Result: " + this.dataAnalyzerInterRuns.getMean() + "\nNines: " + nines + "\nConfidence Interval: [" + this.dataAnalyzerInterRuns.getLowerBoundConfidenceInterval() + "," + this.dataAnalyzerInterRuns.getUpperBoundConfidenceInterval() + "]" + "\nError %: " + 50.0 * ((this.dataAnalyzerInterRuns.getUpperBoundConfidenceInterval() - this.dataAnalyzerInterRuns.getLowerBoundConfidenceInterval()) / this.dataAnalyzerInterRuns.getMean()) + "\nRun size: " + this.getRunSize() + "\nNumer of Runs " + this.getCounterRuns() + "\nTotal Runs " + this.getCounterRuns() * this.getRunSize();
    }

    public void setExperiment(boolean b) {
        this.experiment = b;
    }

    public boolean getExperiment() {
        return this.experiment;
    }

    public void setTaskTransient(ExperimentEngine.TaskTransient taskTransient) {
        this.taskTransient = taskTransient;
    }
}

