/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import org.modcs.tools.spn.model.expressions.Expectation;
import org.modcs.tools.spn.model.expressions.Probability;

public class RewItem
implements Serializable {
    private static final long serialVersionUID = 6896139889580570282L;
    private Probability probability;
    private Expectation expectation;

    public RewItem(Probability probability) {
        this.probability = probability;
    }

    public RewItem(Expectation expectation) {
        this.expectation = expectation;
    }

    public Probability getProbability() {
        return this.probability;
    }

    public double evaluate() throws Exception {
        if (this.probability != null) {
            return this.probability.evaluate();
        }
        if (this.expectation != null) {
            return this.expectation.evaluate();
        }
        throw new Exception("Error Function Evaluate Rew Item");
    }

    public static RewItem parse(String text) {
        Probability probability = Probability.parse(text);
        if (probability != null) {
            return new RewItem(probability);
        }
        Expectation expectation = Expectation.parse(text);
        if (expectation != null) {
            return new RewItem(expectation);
        }
        return null;
    }

    void updateMetrics(double time) throws Exception {
        if (this.probability != null) {
            this.probability.updateMetrics(time);
        } else if (this.expectation != null) {
            this.expectation.updateMetrics(time);
        }
    }
}

