/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import org.modcs.tools.spn.model.expressions.IntegerValue;
import org.modcs.tools.spn.model.expressions.RealConstant;
import org.modcs.tools.spn.model.expressions.RealParameter;
import org.modcs.tools.spn.model.expressions.RewItem;

public class RealValue
implements Serializable {
    private static final long serialVersionUID = 4480848242625923503L;
    private RealConstant realConstant;
    private RealParameter realParameter;
    private RewItem rewItem;
    private IntegerValue integerValue;

    public RealValue(RealConstant realConstant) {
        this.realConstant = realConstant;
    }

    public RealValue(RealParameter realParameter) {
        this.realParameter = realParameter;
    }

    public RealValue(RewItem rewItem) {
        this.rewItem = rewItem;
    }

    public RealValue(IntegerValue integerValue) {
        this.integerValue = integerValue;
    }

    public RewItem getRewItem() {
        return this.rewItem;
    }

    public String toString() {
        if (this.realConstant != null) {
            return this.realConstant.toString();
        }
        if (this.realParameter != null) {
            return this.realParameter.toString();
        }
        if (this.rewItem != null) {
            return this.rewItem.toString();
        }
        if (this.integerValue != null) {
            return this.integerValue.toString();
        }
        return "";
    }

    public static RealValue parse(String text) {
        RealValue result = null;
        RealParameter realParameter = RealParameter.parse(text);
        if (realParameter != null) {
            return new RealValue(realParameter);
        }
        RealConstant realConstant = RealConstant.parse(text);
        if (realConstant != null) {
            return new RealValue(realConstant);
        }
        RewItem rewItem = RewItem.parse(text);
        if (rewItem != null) {
            return new RealValue(rewItem);
        }
        IntegerValue integerValue = IntegerValue.parse(text);
        if (integerValue != null) {
            return new RealValue(integerValue);
        }
        return result;
    }

    public double evaluate() throws Exception {
        if (this.realConstant != null) {
            return this.realConstant.evaluate();
        }
        if (this.realParameter != null) {
            return this.realParameter.evaluate();
        }
        if (this.rewItem != null) {
            return this.rewItem.evaluate();
        }
        if (this.integerValue != null) {
            return this.integerValue.evaluate();
        }
        throw new Exception("Evaluate Real Value");
    }

    void updateMetrics(double time) throws Exception {
        if (this.rewItem != null) {
            this.rewItem.updateMetrics(time);
        }
    }
}

