/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import org.modcs.tools.Util.Util;
import org.modcs.tools.spn.model.expressions.IntegerValue;
import org.modcs.tools.spn.model.expressions.NumericOperator;

public class MarkingFunction
implements Serializable {
    private static final long serialVersionUID = -5187561612912794844L;
    public MarkingFunction markingFunctionLeft;
    public NumericOperator numericOperator;
    public MarkingFunction markingFunctionRight;
    public IntegerValue integerValue;

    public MarkingFunction(MarkingFunction markingFunctionLeft, NumericOperator numericOperator, MarkingFunction markingFunctionRight) {
        this.markingFunctionLeft = markingFunctionLeft;
        this.numericOperator = numericOperator;
        this.markingFunctionRight = markingFunctionRight;
    }

    public MarkingFunction(IntegerValue integerValue) {
        this.integerValue = integerValue;
    }

    public static int getRootOperatorPosition(String text) {
        int delta = 0;
        int position = Integer.MIN_VALUE;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '(') {
                ++delta;
            } else if (c == ')') {
                --delta;
            }
            if (!NumericOperator.isValid(c) || delta != 0) continue;
            position = i;
            break;
        }
        return position;
    }

    public static MarkingFunction parse(String text) {
        IntegerValue integerValue = IntegerValue.parse(text);
        if (integerValue != null) {
            return new MarkingFunction(integerValue);
        }
        if (!Util.checkParentheses(text)) {
            return null;
        }
        int rootIndex = MarkingFunction.getRootOperatorPosition(text);
        if (rootIndex == Integer.MIN_VALUE && text.charAt(0) == '(' && text.charAt(text.length() - 1) == ')') {
            text = text.substring(1, text.length() - 1);
            return MarkingFunction.parse(text);
        }
        NumericOperator numericOperator = new NumericOperator(text.charAt(rootIndex));
        String text1 = text.substring(0, rootIndex);
        MarkingFunction leftFunction = MarkingFunction.parse(text1);
        if (leftFunction == null) {
            return null;
        }
        String text2 = text.substring(rootIndex + 1);
        MarkingFunction rigthFunction = MarkingFunction.parse(text2);
        if (rigthFunction == null) {
            return null;
        }
        return new MarkingFunction(leftFunction, numericOperator, rigthFunction);
    }

    public int evaluate() throws Exception {
        boolean result = false;
        if (this.numericOperator != null && this.markingFunctionLeft != null && this.markingFunctionRight != null) {
            if (this.numericOperator.getOperator() == '+') {
                return this.markingFunctionLeft.evaluate() + this.markingFunctionRight.evaluate();
            }
            if (this.numericOperator.getOperator() == '-') {
                return this.markingFunctionLeft.evaluate() - this.markingFunctionRight.evaluate();
            }
            if (this.numericOperator.getOperator() == '*') {
                return this.markingFunctionLeft.evaluate() * this.markingFunctionRight.evaluate();
            }
            if (this.numericOperator.getOperator() == '/') {
                return this.markingFunctionLeft.evaluate() / this.markingFunctionRight.evaluate();
            }
            if (this.numericOperator.getOperator() == '^') {
                return (int)Math.pow(this.markingFunctionLeft.evaluate(), this.markingFunctionRight.evaluate());
            }
        }
        if (this.integerValue != null) {
            return this.integerValue.evaluate();
        }
        throw new Exception("Error evaluate Marking Function");
    }
}

