/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import org.modcs.tools.Util.Util;
import org.modcs.tools.spn.model.expressions.Comparison;
import org.modcs.tools.spn.model.expressions.LogicOperator;

public class LogicCondition
implements Serializable {
    private static final long serialVersionUID = 6259192353445359120L;
    private Comparison comparison;
    private LogicCondition notLogicCondition;
    private LogicCondition logicConditionLeft;
    private LogicOperator logicOperator;
    private LogicCondition logicConditionRight;

    public LogicCondition(LogicCondition notLogicCondition, LogicOperator logicOperator) {
        this.notLogicCondition = notLogicCondition;
        this.logicOperator = logicOperator;
    }

    public LogicCondition(Comparison comparison) {
        this.comparison = comparison;
    }

    public LogicCondition(LogicCondition logicConditionLeft, LogicOperator logicOperator, LogicCondition logicConditionRight) {
        this.logicConditionLeft = logicConditionLeft;
        this.logicOperator = logicOperator;
        this.logicConditionRight = logicConditionRight;
    }

    private static LogicOperator getLogicOperator(String text, int pos) {
        LogicOperator result = null;
        for (int i = 0; i < LogicOperator.getOperators().length; ++i) {
            String operator = LogicOperator.getOperators()[i];
            try {
                if (!text.substring(pos, pos + operator.length()).equals(operator)) continue;
                result = new LogicOperator(operator);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private static int getRootOperator(String text, LogicOperator[] logicOp) {
        int delta = 0;
        int rootIndex = Integer.MIN_VALUE;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '(') {
                ++delta;
            } else if (c == ')') {
                --delta;
            }
            logicOp[0] = LogicCondition.getLogicOperator(text, i);
            if (logicOp[0] == null || delta != 0) continue;
            rootIndex = i;
            break;
        }
        return rootIndex;
    }

    public static LogicCondition parse(String text) {
        Comparison comparison = Comparison.parse(text);
        LogicOperator[] logicOp = new LogicOperator[1];
        if (comparison != null) {
            return new LogicCondition(comparison);
        }
        if (!Util.checkParentheses(text)) {
            return null;
        }
        int rootIndex = LogicCondition.getRootOperator(text, logicOp);
        if (rootIndex == Integer.MIN_VALUE && text.charAt(0) == '(' && text.charAt(text.length() - 1) == ')') {
            text = text.substring(1, text.length() - 1);
            return LogicCondition.parse(text);
        }
        if (rootIndex == Integer.MIN_VALUE) {
            return null;
        }
        if (logicOp[0].getOperator().equals("NOT")) {
            String text1 = text.substring(rootIndex + logicOp[0].getOperator().length());
            LogicCondition notLogicCondition = LogicCondition.parse(text1);
            return new LogicCondition(notLogicCondition, logicOp[0]);
        }
        String text1 = text.substring(0, rootIndex);
        LogicCondition leftLogicCondition = LogicCondition.parse(text1);
        if (leftLogicCondition == null) {
            return null;
        }
        String text2 = text.substring(rootIndex + logicOp[0].getOperator().length());
        LogicCondition rigthLogicCondition = LogicCondition.parse(text2);
        if (rigthLogicCondition == null) {
            return null;
        }
        return new LogicCondition(leftLogicCondition, logicOp[0], rigthLogicCondition);
    }

    public boolean evaluate() throws Exception {
        if (this.comparison != null) {
            return this.comparison.evaluate();
        }
        if (this.notLogicCondition != null && this.logicOperator != null) {
            if (!this.logicOperator.getOperator().equals("NOT")) {
                throw new Exception("Evaluation Error: Logic expressions diferent NOT");
            }
            return !this.notLogicCondition.evaluate();
        }
        if (this.logicOperator != null && this.logicConditionLeft != null && this.logicConditionRight != null) {
            if (this.logicOperator.getOperator().equals("AND")) {
                return this.logicConditionLeft.evaluate() && this.logicConditionRight.evaluate();
            }
            if (this.logicOperator.getOperator().equals("OR")) {
                return this.logicConditionLeft.evaluate() || this.logicConditionRight.evaluate();
            }
        }
        throw new Exception("Evaluation Error: Logic expressions Undefined");
    }
}

