/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.modcs.tools.spn.model.expressions.Expression;
import org.modcs.tools.spn.model.expressions.IfThenCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfElseExpression
implements Serializable {
    private static final long serialVersionUID = 5808905389663938224L;
    private ArrayList<IfThenCondition> ifThenConditions;
    private String stringCondition;
    private Expression elseExpression;
    private Expression singleExpression;
    public static final String ELSE = "ELSE";
    private Expression expression;

    public IfElseExpression(ArrayList<IfThenCondition> ifThenConditions, Expression elseExpression, String text) {
        this.ifThenConditions = ifThenConditions;
        this.elseExpression = elseExpression;
        this.stringCondition = text;
    }

    public IfElseExpression(Expression expression, String text) {
        this.singleExpression = expression;
        this.stringCondition = text;
    }

    public String getStringCondition() {
        return this.stringCondition;
    }

    public void setStringCondition(String stringCondition) {
        this.stringCondition = stringCondition;
    }

    public static ArrayList<IfThenCondition> extractIfThens(String text) {
        ArrayList<IfThenCondition> thenConditions = new ArrayList<IfThenCondition>();
        StringTokenizer stringTokenizer = new StringTokenizer(text, "IF");
        while (stringTokenizer.hasMoreTokens()) {
            String temp = stringTokenizer.nextToken();
            temp = "IF" + temp;
            IfThenCondition ifThenCondition = IfThenCondition.parse(temp);
            if (ifThenCondition == null) break;
            thenConditions.add(ifThenCondition);
        }
        if (thenConditions.size() == 0) {
            return null;
        }
        return thenConditions;
    }

    public static IfElseExpression parse(String text) {
        IfElseExpression ifElseExpression = null;
        int positionElse = text.indexOf(ELSE);
        if (positionElse != -1) {
            String temp = text.substring(0, positionElse);
            ArrayList<IfThenCondition> ifThenConditions = IfElseExpression.extractIfThens(temp);
            if (ifThenConditions == null || ifThenConditions.size() == 0) {
                return null;
            }
            temp = text.substring(positionElse + ELSE.length());
            if (temp == null || temp.equals("")) {
                return null;
            }
            Expression expression = Expression.parse(temp);
            if (expression == null) {
                return null;
            }
            ifElseExpression = new IfElseExpression(ifThenConditions, expression, text);
        } else {
            Expression expression = Expression.parse(text);
            if (expression != null) {
                ifElseExpression = new IfElseExpression(expression, text);
            }
        }
        return ifElseExpression;
    }

    public double evaluate() throws Exception {
        double result = 0.0;
        if ((this.ifThenConditions == null || this.ifThenConditions.isEmpty()) && this.singleExpression == null) {
            throw new Exception("Evaluate Error IfThenExpression");
        }
        if (this.singleExpression != null) {
            return this.singleExpression.evaluate();
        }
        for (int i = 0; i < this.ifThenConditions.size(); ++i) {
            IfThenCondition ifThenCondition = this.ifThenConditions.get(i);
            try {
                result = ifThenCondition.evaluate();
                return result;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return this.elseExpression.evaluate();
    }
}

